<?php

use App\Http\Controllers\Api\AuthControllerV1;
use App\Http\Controllers\Api\EncDecController;
use App\Http\Controllers\Api\PtwControllerV1;
use App\Http\Controllers\Api\PtwMasterListControllerV1;
use App\Http\Controllers\Api\MasterWorkerControllerV1;
use App\Http\Controllers\DateController;
use App\Http\Controllers\SystemController;
use Illuminate\Support\Facades\Route;



/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::get('cc', [SystemController::class, 'cc']);
Route::get('mg', [SystemController::class, 'mg']);
Route::get('prgtab', [SystemController::class, 'removeAllTables']);

Route::post('DataEnc', [EncDecController::class, 'dataEncryption']);
Route::post('DataDec', [EncDecController::class, 'dataDecryption']);

Route::post('ServerDate',[DateController::class, 'index']);

Route::prefix('v1')->group(function () {
   Route::post('login', [AuthControllerV1 ::class, 'login']);
   //should be under sanctum middleware and it will be implemented after proper login
    Route::group(['middleware' => ['XssSanitizer']], function () {
        Route::controller(PtwControllerV1::class)->group(function() {
            Route::get('ptw', 'index');
            Route::post('Ptw/GetPtwList', 'ptwList');
            Route::post('Ptw/GetPtwDetails', 'ptwDetails');
            Route::post('Ptw/AddPtw', 'ptwAdd');
            Route::post('Ptw/CaptchaGenerate', 'createCaptcha');
            Route::post('Ptw/GetPtwDownloadableList', 'ptwDownloadableList');
            Route::post('Ptw/GetDetailsReport', 'ptwDetailsExport');
            Route::post('Ptw/GetActivityLog', 'ptwActivityLog');
            Route::post('Ptw/GetPtwAudit', 'ptwAudit');
        });
        Route::controller(PtwMasterListControllerV1::class)->group(function() {
            Route::post('Ptw/GetPtwMaster', 'masterListPtw');
            Route::post('Ptw/GetPtwMasterCheckList', 'masterChekListPtw');
        });
        Route::controller(MasterWorkerControllerV1::class)->group(function() {
            Route::post('Master/GetWorkerList', 'workerList');
            Route::post('Master/AddWorker', 'workerAdd');
            Route::post('Master/GetWorkerDetails', 'workerDetails');
        });
    });
});


