<?php

namespace App\Services\PTW;

use App\Http\Requests\PTW\AddRequest;
use App\Http\Resources\PTW\PtwResource;
use App\Models\MstSite;
use App\Models\Ptw;
use App\Models\PtwActionHistory;
use App\Models\PtwMapCaptcha;
use App\Models\PtwMapChecklist;
use App\Models\PtwMapDeclaration;
use App\Models\PtwMapFiles;
use App\Models\PtwMapHira;
use App\Models\PtwMapPrecautions;
use App\Models\PtwMapSopPolicies;
use App\Models\PtwMapSopPolicy;
use App\Models\PtwMapWorkers;
use App\Models\PtwMstChecklist;
use App\Models\PtwMstChecklistOption;
use App\Models\PtwMstDeclaration;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\PtwMstType;
use App\Models\MstLocation;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class PtwServices extends PtwResource
{
    public $vvsPtwModel;
    public $page;
    public $pageSize;
    public function __construct()
    {
        $this->vvsPtwModel = new Ptw();
    }
    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'TYPE_ID' => 'TYPE_ID',
            'SITE_ID' => 'SITE_ID',
            'AUTO_GEN_REF_NO' => 'AUTO_GEN_REF_NO',
            'LOCATION_ID' => 'LOCATION_ID',
            'PERMIT_START_TIME'=>'PERMIT_START_TIME',
            'PERMIT_END_TIME'=>'PERMIT_END_TIME',
            'STAGE_ID'=>'STAGE_ID'
        ];
    }

    protected function mapRoleStageTab($requestData,$roleId){
        $tab = $requestData->TAB;
        $stageId = (!empty( $requestData ->STAGE_ID)) ? $requestData ->STAGE_ID : "";
        if( $stageId == "" &&  $tab == "DRAFT") $tab = "DRAFT";
        else if($stageId){

            if( $stageId == 1 ){
                if($roleId == 1) $tab = "DRAFT";
            }
            else if( $stageId == 3 ){
                if($roleId == 1) $tab = "REVIEWED";
                else if($roleId == 2) $tab = "REVIEWED";
                else if($roleId == 3) $tab = "PENDING";
            }
            else if( $stageId == 5 || $stageId == 6 || $stageId == 4 ){
                if($roleId == 1) $tab = "PENDING";
                else if($roleId == 2) $tab = "REVIEWED";
                else if($roleId == 3) $tab = "REVIEWED";
            }
            else if( $stageId == 7 || $stageId == 10 || $stageId == 2 ){
                if($roleId == 1) $tab = "REVIEWED";
                else if($roleId == 2) $tab = "PENDING";
                else if($roleId == 3) $tab = "REVIEWED";
            }
            else if( $stageId == 8 || $stageId == 11 || $stageId == 9 || $stageId == 12 || $stageId == 13){
                if($roleId == 1) $tab = "REVIEWED";
                else if($roleId == 2) $tab = "REVIEWED";
                else if($roleId == 3) $tab = "REVIEWED";
            }
        }
        
        return $tab;
    }

    public function calculatedTab($requestData){
        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "PTW")->pluck("ROLE_ID")->first();
        return $this -> mapRoleStageTab($requestData,$userRoles);
    }
    public function getPtwList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $tab = $requestData->TAB ?? "PENDING";

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "PTW")->pluck("ROLE_ID")->first();


        if(!empty($requestData->STAGE_ID)){
            $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        }

        $query = Ptw::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location', 'sopPolicy', 'contractor', 'stage'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "AUTO_GEN_REF_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        if (strtoupper($tab) == "PENDING") {
            if ($userRoles == 1) {
                $query->whereIn('STAGE_ID', [4,5, 6]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 2) {
                $query->whereIn('STAGE_ID', [2, 7, 10]);
            } elseif ($userRoles == 3) {
                $query->whereIn('STAGE_ID', [3]);
            }
        } elseif (strtoupper($tab) == "REVIEWED") {
            if ($userRoles == 1) {
                $query->whereIn('STAGE_ID', [2, 3,7, 8,9,10,11,12,13]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 2) {
                $query->whereIn('STAGE_ID', [3, 4,5,6, 8,9,11,12,13]);
            } elseif ($userRoles == 3) {
                $query->whereIn('STAGE_ID', [2,4,5,6,7,8,9,10,11,12,13]);
            }
        }elseif(strtoupper($tab) == "DRAFT"){
            if ($userRoles == 1) {
                $query->whereIn('STAGE_ID', [1]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            }
        }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);


        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        return $query->paginate($this->pageSize, ['*'], 'page', $this->page);
    }
    public function getPtwListTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        $tab = $requestData->TAB ?? "PENDING";
        $query = Ptw::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location', 'sopPolicy', 'contractor', 'stage'];

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "PTW")->pluck("ROLE_ID")->first();

        if(!empty($requestData->STAGE_ID)){
            $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        }


        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "AUTO_GEN_REF_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        if (strtoupper($tab) == "PENDING") {
            if ($userRoles == 1) {
                $query->whereIn('STAGE_ID', [4,5, 6]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 2) {
                $query->whereIn('STAGE_ID', [2, 7, 10]);
            } elseif ($userRoles == 3) {
                $query->whereIn('STAGE_ID', [3]);
            }
        } elseif (strtoupper($tab) == "REVIEWED") {
            if ($userRoles == 1) {
                $query->whereIn('STAGE_ID', [2, 3,7, 8,9,10,11,12,13]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 2) {
                $query->whereIn('STAGE_ID', [3, 4,5,6, 8,9,11,12,13]);
            } elseif ($userRoles == 3) {
                $query->whereIn('STAGE_ID', [2,4,5,6,7,8,9,10,11,12,13]);
            }
        }elseif(strtoupper($tab) == "DRAFT"){
            if ($userRoles == 1) {
                $query->whereIn('STAGE_ID', [1]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            }
        }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->count();
    }

    public function getPtwDetails($requestData)
    {
        return Ptw::where("ID", $requestData->PTW_ID)->first();
    }

    public function getLastPtw($requestData)
    {
        return Ptw::where("SITE_ID", $requestData->SITE_ID)->latest()->first();
    }


    protected function autoGenNumberGeneration($requestedData)
    {
        $siteId = $requestedData -> SITE_ID;
        $siteName   = MstSite::where("SITE_ID", $siteId)->pluck("SITE_NAME")->first();
        $initialSearch = "";
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            $initialSearch = "DRAFT_";
        }
        else{
            $initialSearch = "SHW_IND_";
        }

        
       
        $previousNumber = DB::table('PTW')
                            ->where("SITE_ID", $siteId)
                            ->where("AUTO_GEN_REF_NO", "LIKE", $initialSearch . strtoupper($siteName) . "%")
                            ->max(DB::raw("CAST(regexp_replace(\"AUTO_GEN_REF_NO\", '\\D', '', 'g') AS INTEGER)"));
        $previousNumber = $previousNumber ?: 0;

        // Define prefix and suffix
        $prefix = config("constants.PTW_REFERENCE_PREFIX");
        $siteMappingArray = typeIdTextMapping();
        $middle = "_".$siteMappingArray[$requestedData -> SITE_ID]."_";
       
        
        // Increment the last digit based on the value of $previousNumber
        $lastDigit = $previousNumber + 1;

        // Concatenate all parts to form the output
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            return $initialSearch.strtoupper($siteName)."-".$lastDigit;
        }else{
            return $prefix . strtoupper($siteName) . $middle . $lastDigit;
        }
    }

    protected function getStages($requestAction)
    {
        $stageId = 1;
        if (strtoupper($requestAction) == "DRAFT") {
            $stageId = 1;
        } elseif (strtoupper($requestAction) == "SAVE") {
            $stageId = 2;
        } elseif (strtoupper($requestAction) == "MOVE_FORWARD") {
            $stageId = 3;
        } elseif (strtoupper($requestAction) == "SEND_BACK") {
            $stageId = 4;
        } elseif (strtoupper($requestAction) == "APPROVE") {
            $stageId = 5;
        } elseif (strtoupper($requestAction) == "REJECT") {
            $stageId = 6;
        } elseif (strtoupper($requestAction) == "REQUEST_FOR_CLOSURE") {
            $stageId = 7;
        } elseif (strtoupper($requestAction) == "CLOSE") {
            $stageId = 8;
        } elseif (strtoupper($requestAction) == "REQUEST_FOR_SUSPEND") {
            $stageId = 10;
        } elseif (strtoupper($requestAction) == "SUSPEND") {
            $stageId = 11;
        }
        elseif (strtoupper($requestAction) == "RENEW") {
            $stageId = 13;
        }
        return $stageId;
    }

    protected function transformPTWTableData($requestData)
    {
        if (in_array(strtoupper($requestData->ACTION), ["DRAFT", "SAVE","RENEW"])) {

            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];

            if (isset($requestData->SITE_ID)) {
                $processedData["SITE_ID"]  =  $requestData->SITE_ID;
            }
            if (isset($requestData->TYPE_ID)) {
                $processedData["TYPE_ID"]  =  $requestData->TYPE_ID;
            }
            if (isset($requestData->LOCATION_ID)) {
                $processedData["LOCATION_ID"]  =  $requestData->LOCATION_ID;
            }
            if (isset($requestData->PERMIT_START_TIME)) {
                $processedData["PERMIT_START_TIME"]  = createSlashDate($requestData->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->PERMIT_END_TIME)) {
                $processedData["PERMIT_END_TIME"]  =  createSlashDate($requestData->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->DESCRIPTION)) {
                $processedData["DESCRIPTION"]  =  $requestData->DESCRIPTION;
            }
            if (isset($requestData->REMARKS)) {
                $processedData["REMARKS"]  =  $requestData->REMARKS;
            }
            if (isset($requestData->IS_ISOLATION_REQUIRED)) {
                $processedData["IS_ISOLATION_REQUIRED"]  =  $requestData->IS_ISOLATION_REQUIRED;
            }

            if (isset($requestData->IS_CONTRACTOR_INFO_REQUIRED)) {
                $processedData["IS_CONTRACTOR_INFO_REQUIRED"]  =  $requestData->IS_CONTRACTOR_INFO_REQUIRED;
            }
            if (isset($requestData->CONTRACTOR_ID)) {
                $processedData["CONTRACTOR_ID"]  =  $requestData->CONTRACTOR_ID;
            }
            if ($requestData->ID == 0 ) {
               
                $processedData["AUTO_GEN_REF_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                        $this->autoGenNumberGeneration($requestData) : "";
            }else{
                //if PTW is already created as DRAFT and now request for SAVE it then again AUTO_GEN_REF_NO will be updated

                if( strtoupper($requestData->ACTION) == "SAVE"){
                    $ptwDraftAlready = Ptw::where("ID",$requestData->ID)->where("AUTO_GEN_REF_NO","LIKE","DRAFT_%");
                    if($ptwDraftAlready -> exists()){
                        $processedData["AUTO_GEN_REF_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                                $this->autoGenNumberGeneration($requestData) : "";
                    }

                }
            }
            //extra three fields for Hot Work PTW
            if (!empty($requestData->TYPE_ID) && $requestData->TYPE_ID == 2) {
                if (isset($requestData->SPRINKLER_PROTECTION)) {
                    $processedData["SPRINKLER_PROTECTION"]  =  $requestData->SPRINKLER_PROTECTION;
                }
                if (isset($requestData->SMOKE_DETECTION)) {
                    $processedData["SMOKE_DETECTION"]  =  $requestData->SMOKE_DETECTION;
                }
                if (isset($requestData->ON_A_ROOF)) {
                    $processedData["ON_A_ROOF"]  =  $requestData->ON_A_ROOF;
                }
            }
        } else {
            
            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];
            
        }


        if (isset($requestData->ID) &&  $requestData->ID > 0) {
            $processedData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedData["MODIFIED_ON"] = currentDateTime();
        } else {
            $processedData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedData["CREATED_ON"] = currentDateTime();
        }
        return $processedData;
    }

    protected function transformPTWMapSOPPoliciesTableData($requestData, $ptwId)
    {
        $processedData = [];
        if (isset($requestData->SOP_POLICY_ID)) {
            if (count($requestData->SOP_POLICY_ID)) {
                foreach ($requestData->SOP_POLICY_ID as $value) {
                    $processedData[] = [
                        "PTW_ID" => $ptwId,
                        "SOP_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    protected function transformPTWMapHiraTableData($requestData, $ptwId)
    {
        $processedData = [];
        if (isset($requestData->HIRA_REFERENCE_ID)) {
            if (count($requestData->HIRA_REFERENCE_ID)) {
                foreach ($requestData->HIRA_REFERENCE_ID as $value) {
                    $processedData[] = [
                        "PTW_ID" => $ptwId,
                        "HIRA_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    protected function transformPTWMapWorkersTableData($requestData, $ptwId)
    {
        $processedData = [];
        if (isset($requestData->RISK)) {
            if (count($requestData->RISK) > 0) {
                foreach ($requestData->RISK as $value) {
                    $processedData[] = [
                        "PTW_ID" => $ptwId,
                        "WORKER_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }
    protected function transformPTWMapDeclarationTableData($requestData, $ptwId)
    {
        $processedData = [];
        if (isset($requestData->DECLARATION_ID)) {
            if (count($requestData->DECLARATION_ID) > 0) {
                foreach ($requestData->DECLARATION_ID as $value) {
                    $processedData[] = [
                        "PTW_ID" => $ptwId,
                        "DECLARATION_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    protected function transformPTWMapPrecautionTableData($requestData, $ptwId)
    {
        $processedData = [];
        if (isset($requestData->PRECAUTIONS)) {
            if (count($requestData->PRECAUTIONS) > 0) {
                foreach ($requestData->PRECAUTIONS as $value) {
                    $processedData[] = [
                        "PTW_ID" => $ptwId,
                        "TAG_NO" => $value->TAG_NO,
                        "LOCATION" => $value->LOCATION,
                        "ACTION_ID" => $value->ACTION_ID,
                        "TAGGED_BY" => $value->TAGGED_LOCKED_BY,
                        "TAGGED_ON" => $value->TAGGED_LOCKED_ON,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    protected function transformPTWMapCheckListTableData($requestData, $ptwId)
    {
        $processedData = [];
        if (isset($requestData->GENERAL_CHECKLIST)) {
            if (count($requestData->GENERAL_CHECKLIST)) {
                foreach ($requestData->GENERAL_CHECKLIST as $value) {
                    $processedData[] = [
                        "PTW_ID" => $ptwId,
                        "CHECKLIST_ID" => $value->CHECKLIST_ID ?? 999,
                        // "CHECKLIST_NAME" => PtwMstChecklist::where("CHECKLIST_ID", $value->CHECKLIST_ID)->pluck("CHECKLIST_NAME")->first(),
                        "CHECKLIST_NAME" => PtwMstChecklist::where("CHECKLIST_ID", $value->CHECKLIST_ID)->pluck("CHECKLIST_NAME")->first() ?? $value->CHECKLIST_NAME,
                        "OPTION_ID" => $value->OPTION_ID ?? 999,
                        // "OPTION_NAME" => PtwMstChecklistOption::where("CHECKLIST_OPTION_ID", $value->OPTION_ID)->pluck("CHECKLIST_OPTION_NAME")->first(),
                        "OPTION_NAME" => PtwMstChecklistOption::where("CHECKLIST_OPTION_ID", $value->OPTION_ID)->pluck("CHECKLIST_OPTION_NAME")->first() ?? $value->OPTION_NAME,
                        "CHECKLIST_TYPE" => PtwMstChecklist::where("CHECKLIST_ID", $value->CHECKLIST_ID)->pluck("CHECKLIST_TYPE")->first() ?? 1,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        if (isset($requestData->PPE_CHECKLIST)) {
            if (count($requestData->PPE_CHECKLIST)) {
                foreach ($requestData->PPE_CHECKLIST as $value) {
                    $processedData[] = [
                        "PTW_ID" => $ptwId,
                        "CHECKLIST_ID" => $value->CHECKLIST_ID ?? 999,
                        "CHECKLIST_NAME" => PtwMstChecklist::where("CHECKLIST_ID", $value->CHECKLIST_ID)->pluck("CHECKLIST_NAME")->first() ?? $value->CHECKLIST_NAME,
                        "OPTION_ID" => $value->OPTION_ID ?? 999,
                        "OPTION_NAME" => PtwMstChecklistOption::where("CHECKLIST_OPTION_ID", $value->OPTION_ID)->pluck("CHECKLIST_OPTION_NAME")->first() ?? $value->OPTION_NAME,
                        "CHECKLIST_TYPE" => PtwMstChecklist::where("CHECKLIST_ID", $value->CHECKLIST_ID)->pluck("CHECKLIST_TYPE")->first() ?? 1,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    public function ptwFileUpload($request, $ptwId)
    {

        if ($ptwId) {
            $uploadPath = './' . config('constants.PTW_FILE_UPLOAD_PATH');
            $absoluteBasePath = public_path(config('constants.PTW_FILE_UPLOAD_PATH'));
            if (!file_exists($uploadPath)) {
                mkdir($uploadPath, 0755, true);
            }

            $fileList = (isset($request->FILES)) ? $request->FILES : [];


            if (count($fileList)) {
                foreach ($fileList as $fileData) {
                    if ($fileData->FILE_ID == 0) {
                        $base64string = $fileData->FILE;
                        if ($base64string) {
                            list($type, $imageBase64) = explode(";base64,", $base64string);
                            list(, $extension) = explode('/', $type);

                            $newFileName = uniqid() . '.' . $extension;
                            $filePath = $absoluteBasePath . $newFileName;

                            if (File::put($filePath, base64_decode($imageBase64))) {


                                $file = new PtwMapFiles([
                                    'PTW_ID' => $ptwId,
                                    'FILE_NAME' => $newFileName,
                                    'FILE_CAPTION' => $fileData->FILE_CAPTION,
                                    'FILE_PATH' => $filePath,
                                    'CREATED_BY' => $request->CREATED_BY
                                ]);

                                $file->save();
                            }
                        }
                    } else {
                        //request for deletion of the file
                        $fileDetails = PtwMapFiles::where('FILE_ID', $fileData->FILE_ID)->first();
                        if ($fileDetails) {
                            $fileDeleted = PtwMapFiles::where('FILE_ID', $fileData->FILE_ID)->delete();
                            if ($fileDeleted) {
                                @unlink($absoluteBasePath . $fileDetails->FILE_NAME);
                            }
                        }
                    }
                }
            }
        }
    }


    public function softDeleteForAssociatedPTWTables($model, $ptwId, $requestData)
    {
        return $model::where("PTW_ID", $ptwId)->where("IS_DELETED", 0)
            ->update([
                "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                "MODIFIED_ON" => currentDateTime()
            ]);
    }

    public function renewal($requestData){
        $ptwQuery = Ptw::where("IS_DELETED",0)->where("IS_ACTIVE",1)->where("ID",$requestData->PARENT_PTW_ID)->where("STAGE_ID",5);
        $renewdPtwId = 0;
        if($ptwQuery-> exists()){
            $ptwData = $ptwQuery -> first();
            $prevPtw = Ptw::where("ID", $requestData->PARENT_PTW_ID)->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->first();

            $ptw["SITE_ID"] = $ptwData->SITE_ID;
            $ptw["AUTO_GEN_REF_NO"] = $ptwData->AUTO_GEN_REF_NO;
            $ptw["TYPE_ID"] = $ptwData->TYPE_ID;
            $ptw["LOCATION_ID"] = $ptwData->LOCATION_ID;
            $ptw["DESCRIPTION"] = $ptwData->DESCRIPTION;
            $ptw["IS_CONTRACTOR_INFO_REQUIRED"] = $ptwData->IS_CONTRACTOR_INFO_REQUIRED;
            $ptw["CONTRACTOR_ID"] = $ptwData->CONTRACTOR_ID;
            $ptw["REMARKS"] = $ptwData->REMARKS;
            $ptw["IS_ISOLATION_REQUIRED"] = $ptwData->IS_ISOLATION_REQUIRED;
            $ptw["SPRINKLER_PROTECTION"] = $ptwData->SPRINKLER_PROTECTION;
            $ptw["SMOKE_DETECTION"] = $ptwData->SMOKE_DETECTION;
            $ptw["ON_A_ROOF"] = $ptwData->ON_A_ROOF;
            $ptw['PERMIT_START_TIME'] = createSlashDate($requestData->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT"));
            $ptw['PERMIT_END_TIME'] = createSlashDate($requestData->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT"));
            $ptw['TOP_PARENT_PTW_ID'] = createSlashDate($requestData->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT"));
            $ptw["PARENT_PTW_ID"] = $requestData->PARENT_PTW_ID ?? null;
            $ptw['TOP_PARENT_PTW_ID'] = ($prevPtw->RENEWAL_COUNT == 0) ? 
                                                $requestData->PARENT_PTW_ID : $prevPtw-> TOP_PARENT_PTW_ID;
            $ptw['RENEWAL_COUNT'] = ($prevPtw->RENEWAL_COUNT + 1);
            $ptw['CREATED_BY'] = $requestData->CREATED_BY;
            $ptw["CREATED_ON"] = currentDateTime();
            $ptw['STAGE_ID'] = 2;
            $renewdPtwIdInsert = Ptw::create($ptw);
            $renewdPtwId = $renewdPtwIdInsert -> ID;
          
            //PTW_MAP_SOP_POLICIES
            $ptwSopPolicyExist = PtwMapSopPolicies::where("PTW_ID",$requestData->PARENT_PTW_ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0);
            
            if($ptwSopPolicyExist ->exists()){
                $ptwSOPPoliciesData = $ptwSopPolicyExist -> get();
                
                foreach($ptwSOPPoliciesData -> toArray() as $k => $v){
                    $ptwSopPol["PTW_ID"] = $renewdPtwId;
                    $ptwSopPol["SOP_ID"] = $v["SOP_ID"];
                    $ptwSopPol["CREATED_BY"] = $requestData->CREATED_BY;
                    $ptwSopPol["CREATED_ON"] = currentDateTime();
                    PtwMapSopPolicies::create($ptwSopPol);
                }
            }

            //PTW_MAP_HIRA
            $ptwMapHiraExists = PtwMapHira::where("PTW_ID",$requestData->PARENT_PTW_ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0);
            if($ptwMapHiraExists ->exists()){
                $ptwMapHiraData = $ptwMapHiraExists -> get();
               
                foreach($ptwMapHiraData -> toArray() as $k => $v){
                    $ptwSopPol1["PTW_ID"] = $renewdPtwId;
                    $ptwSopPol1["HIRA_ID"] = $v["HIRA_ID"];
                    $ptwSopPol1["CREATED_BY"] = $requestData->CREATED_BY;
                    PtwMapHira::create($ptwSopPol1);
                }
            }
           
            //PTW_MAP_WORKERS
            $ptwMapWorkersExists = PtwMapWorkers::where("PTW_ID",$requestData->PARENT_PTW_ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0);
            if($ptwMapWorkersExists ->exists()){
                $ptwMapWorkersData = $ptwMapWorkersExists -> get();
                foreach($ptwMapWorkersData -> toArray() as $k => $v){
                    $ptwSopPol2["PTW_ID"] = $renewdPtwId;
                    $ptwSopPol2["WORKER_ID"] = $v["WORKER_ID"];
                    $ptwSopPol2["CREATED_BY"] = $requestData->CREATED_BY;
                    $ptwSopPol2["CREATED_ON"] = currentDateTime();
                    PtwMapWorkers::create($ptwSopPol2);
                }
            }

            //PTW_MAP_DECLARATION
            $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                ->where("DECLARATION_GROUP", "PTW_ADD")->pluck("DECLARATION_ID")->all();
            $PtwMapDeclarationExists = PtwMapDeclaration::where("PTW_ID",$requestData->PARENT_PTW_ID)
                                        ->where("IS_ACTIVE",1)->where("IS_DELETED",0)
                                        ->whereIn("DECLARATION_ID",$allDeclarationData);
            if($PtwMapDeclarationExists ->exists()){
                $ptwMapDeclarationData = $PtwMapDeclarationExists -> get();
                foreach($ptwMapDeclarationData -> toArray() as $k => $v){
                    $ptwSopPol3["PTW_ID"] = $renewdPtwId;
                    $ptwSopPol3["DECLARATION_ID"] = $v["DECLARATION_ID"];
                    $ptwSopPol3["CREATED_BY"] = $requestData->CREATED_BY;
                    $ptwSopPol3["CREATED_ON"] = currentDateTime();
                    PtwMapDeclaration::create($ptwSopPol3);
                }
            }

            //insert into PTW_MAP_CHECKLIST
            $ptwMapChecklistExists = PtwMapChecklist::where("PTW_ID",$requestData->PARENT_PTW_ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0);
            if($ptwMapChecklistExists ->exists()){
                $ptwMapChecklistData = $ptwMapChecklistExists -> get();
                foreach($ptwMapChecklistData -> toArray() as $k => $v){
                    $ptwSopPol4["PTW_ID"] = $renewdPtwId;
                    $ptwSopPol4["CHECKLIST_ID"] = $v["CHECKLIST_ID"];
                    $ptwSopPol4["CHECKLIST_NAME"] = $v["CHECKLIST_NAME"];
                    $ptwSopPol4["OPTION_ID"] = $v["OPTION_ID"];
                    $ptwSopPol4["OPTION_NAME"] = $v["OPTION_NAME"];
                    $ptwSopPol4["CHECKLIST_TYPE"] = $v["CHECKLIST_TYPE"];
                    $ptwSopPol4["CREATED_BY"] = $requestData->CREATED_BY;
                    $ptwSopPol4["CREATED_ON"] = currentDateTime();
                    PtwMapChecklist::create($ptwSopPol4);
                }
            }

            //insert into PTW_MAP_PRECAUTIONS
            $ptwMapPrecautionExists = PtwMapPrecautions::where("PTW_ID",$requestData->PARENT_PTW_ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0);
            if($ptwMapPrecautionExists ->exists()){
                $ptwMapPrecautionData = $ptwMapPrecautionExists -> get();
                foreach($ptwMapPrecautionData -> toArray() as $k => $v){
                    $ptwSopPol5["PTW_ID"] = $renewdPtwId;
                    $ptwSopPol5["TAG_NO"] = $v["TAG_NO"];
                    $ptwSopPol5["LOCATION"] = $v["LOCATION"];
                    $ptwSopPol5["ACTION_ID"] = $v["ACTION_ID"];
                    $ptwSopPol5["TAGGED_BY"] = $v["TAGGED_BY"];
                    $ptwSopPol5["TAGGED_ON"] = $v["TAGGED_ON"];
                    $ptwSopPol5["CREATED_BY"] = $requestData->CREATED_BY;
                    $ptwSopPol5["CREATED_ON"] = currentDateTime();
                    PtwMapPrecautions::create($ptwSopPol5);
                }
            }

            //insert into PTW_MAP_FILES
            $ptwMapFilExists = PtwMapFiles::where("PTW_ID",$requestData->PARENT_PTW_ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0);
            if($ptwMapFilExists ->exists()){
                $ptwMapFilData = $ptwMapFilExists -> get();
                foreach($ptwMapFilData -> toArray() as $k => $v){
                    $ptwSopPol6["PTW_ID"] = $renewdPtwId;
                    $ptwSopPol6["FILE_NAME"] = $v["FILE_NAME"];
                    $ptwSopPol6["FILE_CAPTION"] = $v["FILE_CAPTION"];
                    $ptwSopPol6["CREATED_BY"] = $requestData->CREATED_BY;
                    $ptwSopPol6["CREATED_ON"] = currentDateTime();
                    //$ptwSopPol6["FILE_PATH"] = $v["FILE_PATH"];
                    PtwMapFiles::create($ptwSopPol6);
                }
            }

            //insert history for previous PTW id
            // PtwActionHistory::insert(
            //     [
            //         "PTW_ID" => $prevPtw->PARENT_PTW_ID,
            //         "ACTION_TAKER_ID" => $requestData->CREATED_BY,
            //         "STAGE_ID"  => 13,
            //         "COMMENTS"  => $requestData->REMARKS ?? "",
            //         "CREATED_BY" => $requestData->CREATED_BY,
            //         "CREATED_ON" => currentDateTime()
            //     ]
            // );
            // //insert history for new ptw id
            // PtwActionHistory::insert(
            //     [
            //         "PTW_ID" => $renewdPtwId,
            //         "ACTION_TAKER_ID" => $requestData->CREATED_BY,
            //         "STAGE_ID"  =>2,
            //         "COMMENTS"  => $requestData->REMARKS ?? "",
            //         "CREATED_BY" => $requestData->CREATED_BY,
            //         "CREATED_ON" => currentDateTime()
            //     ]
            // );

            //update parent ptw id
            Ptw::where("ID", $prevPtw->ID)->update([
                "STAGE_ID"  => 13,
                "MODIFIED_BY" => $requestData->CREATED_BY,
                "MODIFIED_ON" => currentDateTime()
            ]);
        }
        return $renewdPtwId;
    }
    public function save($requestData)
    {

        $ptwId = "";
        if (isset($requestData->ID) && $requestData->ID) {
            $ptwId = Ptw::where("ID", $requestData->ID)->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->pluck("ID")->first();
            $ptwStageId = Ptw::where("ID", $requestData->ID)->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->pluck("STAGE_ID")->first();
            $requestedStageId = $this -> getStages($requestData->ACTION);
            
            if( in_array($ptwStageId,[4,6])){
                if( $requestedStageId ==1 ){

                }else{
                    if($ptwStageId > $requestedStageId){
                        return "";
                    }
                }                
            }else if($ptwStageId !=1 && ($ptwStageId  == $requestedStageId)){
                return "";
            }
            else{
                if($ptwStageId > $requestedStageId){
                    return "";
                }
            }
            

        }
        // DB::beginTransaction();
        // try {
           

            if (isset($requestData->ACTION) && strtoupper($requestData->ACTION) == "RENEW") {
                $ptwId = $this -> renewal($requestData);
            }else{
                $processedData = $this->transformPTWTableData($requestData);
                if ($ptwId > 0) {
                    //update ptw tables and upsert all associated tables
                    Ptw::where("ID", $ptwId)->update($processedData);
                } else {
                    //insert ptw tables and insert all associated tables
                    //insert into PTW table
                    $ptwInsert = Ptw::create($processedData);
                    $ptwId = $ptwInsert->ID;
                }

                //insert into PTW_MAP_SOP_POLICIES
                $ptwMapSOPPoliciesData = $this->transformPTWMapSOPPoliciesTableData($requestData, $ptwId);
                if (count($ptwMapSOPPoliciesData)) {
                    //soft delete old data if exists
                    //$this -> softDeleteForAssociatedPTWTables("PtwMapSopPolicies",$ptwId,$requestData);
                    PtwMapSopPolicies::where("PTW_ID", $ptwId)->where("IS_DELETED", 0)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                        ]);
                    //insert new data
                    PtwMapSopPolicies::insert($ptwMapSOPPoliciesData);
                }

                //insert into PTW_MAP_HIRA
                $ptwMapHiraData = $this->transformPTWMapHiraTableData($requestData, $ptwId);
                if (count($ptwMapHiraData)) {
                    //soft delete old data if exists
                    //$this -> softDeleteForAssociatedPTWTables("PtwMapHira",$ptwId,$requestData);
                    PtwMapHira::where("PTW_ID", $ptwId)->where("IS_DELETED", 0)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                        ]);
                    //insert new data
                    PtwMapHira::insert($ptwMapHiraData);
                }

                //insert into PTW_MAP_WORKERS
                $ptwMapWorkersData = $this->transformPTWMapWorkersTableData($requestData, $ptwId);

                if (count($ptwMapWorkersData)) {
                    //soft delete old data if exists
                    //$this -> softDeleteForAssociatedPTWTables("PtwMapWorkers",$ptwId,$requestData);
                    PtwMapWorkers::where("PTW_ID", $ptwId)->where("IS_DELETED", 0)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                        ]);
                    //insert new data
                    PtwMapWorkers::insert($ptwMapWorkersData);
                }

                //insert into PTW_MAP_DECLARATION

                $ptwMapDeclarationData = $this->transformPTWMapDeclarationTableData($requestData, $ptwId);
                if (count($ptwMapDeclarationData)) {
                    //soft delete old data if exists
                    $addRequestClass = new AddRequest();
                    $declarationSectionId = $addRequestClass->getDeclarationSectionbyAction($requestData->ACTION);

                    if ($declarationSectionId == 1) {
                        $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "PTW_ADD")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 2) {
                        $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "PTW_MOVE_FORWARD")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 3) {
                        $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "PTW_APPROVE")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 4) {
                        $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "PTW_REJECT")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 5) {
                        $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "PTW_REQUEST_FOR_CLOSURE")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 6) {
                        $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "PTW_CLOSE")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 7) {
                        $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "PTW_SUSPEND")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 8) {
                        $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "PTW_REQUEST_FOR_SUSPEND")->pluck("DECLARATION_ID")->all();
                    } else {
                        $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->whereNot("DECLARATION_GROUP", "PTW_ADD")->pluck("DECLARATION_ID")->all();
                    }

                    PtwMapDeclaration::where("PTW_ID", $ptwId)->where("IS_DELETED", 0)
                        ->whereIn("DECLARATION_ID", $allDeclarationData)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                        ]);
                    //insert new data
                    PtwMapDeclaration::insert($ptwMapDeclarationData);
                }

                //insert into PTW_MAP_CHECKLIST
                $ptwMapCheckListData = $this->transformPTWMapCheckListTableData($requestData, $ptwId);
                if (count($ptwMapCheckListData)) {
                    //soft delete old data if exists
                    //$this -> softDeleteForAssociatedPTWTables("PtwMapChecklist",$ptwId,$requestData);
                    PtwMapChecklist::where("PTW_ID", $ptwId)->where("IS_DELETED", 0)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                        ]);
                    //insert new data
                    PtwMapChecklist::insert($ptwMapCheckListData);
                }


                //insert into PTW_MAP_PRECAUTIONS
                $ptwMapPrecautionData = $this->transformPTWMapPrecautionTableData($requestData, $ptwId);
                if (count($ptwMapPrecautionData)) {
                    //soft delete old data if exists
                    //$this -> softDeleteForAssociatedPTWTables("PtwMapPrecautions",$ptwId,$requestData);
                    PtwMapPrecautions::where("PTW_ID", $ptwId)->where("IS_DELETED", 0)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                        ]);
                    //insert new data
                    PtwMapPrecautions::insert($ptwMapPrecautionData);
                }


                //insert into PTW_MAP_FILES
                $this->ptwFileUpload($requestData, $ptwId);

                // if close action
                if( strtoupper($requestData -> ACTION) == "CLOSE" ){
                    //update all action by in map precaution table
                    
                    // Get the existing ACTION_ID for all records associated with the PTW_ID
                    $existingActionIds = PtwMapPrecautions::where("PTW_ID", $ptwId)
                                        ->where("IS_ACTIVE", 1)->where("IS_DELETED", 0)->pluck("ACTION_ID");

                    // Determine the new ACTION_ID for each existing value
                    $newActionIds = $existingActionIds->map(function ($existingActionId) {
                                        return $existingActionId == 1 ? 3 : ($existingActionId == 2 ? 4 : null);
                                    });

                    // Update the ACTION_ID for all relevant records
                    PtwMapPrecautions::where("PTW_ID", $ptwId)
                                        ->where("IS_ACTIVE", 1)->where("IS_DELETED", 0)
                                        ->update(["ACTION_ID" => $newActionIds->toArray()]);
                }


                //insert into log table
                PtwActionHistory::insert(
                    [
                        "PTW_ID" => $ptwId,
                        "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                        "STAGE_ID"  => $this->getStages($requestData->ACTION),
                        "COMMENTS"  => $requestData->REMARKS ?? "",
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ]
                );
            }
                
            // DB::commit();

            // If the transaction is committed successfully, you can return a response or perform other actions
            if($ptwId != ""){

                return Ptw::where("ID", $ptwId)->pluck("AUTO_GEN_REF_NO")->first();
            }else{
                return "";
            }
        // } catch (\Exception $e) {
        //     // If an exception occurs during the transaction, rollback the changes
        //     DB::rollBack();

        //     // You can handle the exception here, log it, or return an error response
        //     return "";
        // }
    }



    public function ptwCaptchaUpdate($requestData, $captchaText)
    {
        $ptwId = "";
        if (isset($requestData->ID) && $requestData->ID) {
            $ptwId = Ptw::where("ID", $requestData->ID)->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->pluck("ID")->first();
        }

        if ($ptwId == "") return "";

        try {

            DB::beginTransaction();
            Ptw::where("ID", $ptwId)->update(["CAPTCHA_CODE" => $captchaText]);

            //update MAP PTW CAPTCHA table
            PtwMapCaptcha::create([
                "PTW_ID" => $requestData->ID,
                "CAPCHA_CODE" => $captchaText,
                "CREATED_BY" => $requestData->CREATED_BY
            ]);



            DB::commit();
            return "Captcha Code updated.";
        } catch (\Exception $e) {
            // If an exception occurs during the transaction, rollback the changes
            DB::rollBack();

            // You can handle the exception here, log it, or return an error response
            return "";
        }
    }

    public function getPtwDownloadableList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = Ptw::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location', 'sopPolicy', 'contractor', 'stage',
                                  'actionRequestedHistory', 'actionApprovedHistory', 'actionRejectedHistory',
                                'actionClosedHistory', 'actionSuspendedHistory', 'actionReviewedHistory'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "AUTO_GEN_REF_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }

        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        $query->with(['actionRequestedHistory.actionTracker']);
        $query->with(['actionReviewedHistory.actionTracker']);
        $query->with(['actionApprovedHistory.actionTracker']);
        $query->with(['actionRejectedHistory.actionTracker']);
        $query->with(['actionClosedHistory.actionTracker']);
        $query->with(['actionSuspendedHistory.actionTracker']);

        // Fetch action history data
        return  $query->get();

    }

    public function getSearchCriteriaList($requestData)
    {
        $searchCriteria =[];
        if (!empty($requestData->TYPE_ID) && isset($requestData->TYPE_ID)) {
            $type = PtwMstType::find($requestData->TYPE_ID);
            if ($type) {
                $typeName = $type->TYPE_NAME;
            }
        }
        if (!empty($requestData->LOCATION_ID) && isset($requestData->LOCATION_ID)) {
            $location = MstLocation::find($requestData->LOCATION_ID);
            if ($location) {
                $locationName = $location->LOCATION_NAME;
            }
        }
        if (!empty($requestData->SITE_ID) && isset($requestData->SITE_ID)) {
            $site = MstSite::find($requestData->SITE_ID);
            if ($site) {
                $siteName = $site->SITE_NAME;
            }
        }

        if(isset($requestData->SITE_ID)){
            $searchCriteria["SITE_NAME"] = $siteName;
        }
        if(isset($requestData->TYPE_ID)){
            $searchCriteria["PTW_TYPE"] = $typeName;
        }
        if(isset($requestData->AUTO_GEN_REF_NO)){
            $searchCriteria["PTW_REFERENCE_NO"] = $requestData->AUTO_GEN_REF_NO;
        }
        if(isset($requestData->LOCATION_ID)){
            $searchCriteria["PTW_REFERENCE_NO"] = $locationName;
        }
        if(isset($requestData->PERMIT_START_TIME) && isset($requestData->PERMIT_END_TIME) ){
            $searchCriteria["DURATION"] = $requestData->PERMIT_START_TIME . " To " . $requestData->PERMIT_END_TIME;
        }

        return $searchCriteria;
    }

    public function workerExistsInPtwDuration($workerIds,$permitStartTime,$permitEndTime,$siteId){
        $ptwMapWorkerQuery = PTWMapWorkers::leftJoin('PTW', 'PTW.ID', '=', 'PTW_MAP_WORKERS.PTW_ID')
                    ->whereIn('PTW_MAP_WORKERS.WORKER_ID', $workerIds)
                    ->where('PTW.IS_DELETED', 0)
                    ->where('PTW.IS_ACTIVE', 1)
                    ->where('PTW.PERMIT_START_TIME', '>=', $permitStartTime)
                    ->where('PTW.PERMIT_END_TIME', '<=', $permitEndTime)
                    ->whereNotIn('PTW.STAGE_ID',[1,8,9,11,12])
                    ->where('PTW.SITE_ID', $siteId);
        return $ptwMapWorkerQuery->exists() ?? 0;
    }
}
