<?php

namespace App\Services\PTW;

use App\Http\Resources\PTW\PtwCheckListResource;
use App\Models\PtwMstChecklist;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class PtwCheckListServices extends PtwCheckListResource
{
    public $vvsPtCheckListModel;
    public function __construct(){
        $this->vvsPtCheckListModel = new PtwMstChecklist();
    }
    
    public function getGeneralPtwCheckList($rawRequest){
        return PtwMstChecklist::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
        ->where("TYPE_ID", $rawRequest->TYPE_ID)->where("CHECKLIST_TYPE", 1)->orderBy('ORDER_NO')->get();
    }

    public function getPpePtwCheckList($rawRequest){
        return PtwMstChecklist::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
        ->where("TYPE_ID", $rawRequest->TYPE_ID)->where("CHECKLIST_TYPE", 2)->orderBy('ORDER_NO')->get();
    }

    public function getMapGeneralPtwCheckList($ptw_id,$type_id,$afterSubmit){
        if( $afterSubmit == 1 ){
            return PtwMstChecklist::select(
                        'PTW_MST_CHECKLIST.CHECKLIST_ID', 
                        'PTW_MST_CHECKLIST.CHECKLIST_NAME', 
                        'PTW_MST_CHECKLIST.TYPE_ID', 
                        'PTW_MST_CHECKLIST.IS_APPLICABLE_FOR_NIGHT',
                        'PTW_MST_CHECKLIST.CHECKLIST_TYPE', 
                        'PTW_MAP_CHECKLIST.MAP_CHECKLIST_ID',
                        'PTW_MAP_CHECKLIST.OPTION_ID',
                        'PTW_MAP_CHECKLIST.OPTION_NAME',
                        'PTW_MAP_CHECKLIST.IS_ACTIVE',
                        'PTW_MAP_CHECKLIST.IS_DELETED'
                    )
                    ->leftJoin('PTW_MAP_CHECKLIST', function($join) use ($ptw_id) {
                        $join->on('PTW_MST_CHECKLIST.CHECKLIST_ID', '=', 'PTW_MAP_CHECKLIST.CHECKLIST_ID')
                            ->where('PTW_MAP_CHECKLIST.PTW_ID', $ptw_id)
                            ->where('PTW_MAP_CHECKLIST.IS_ACTIVE', 1)
                            ->where('PTW_MAP_CHECKLIST.IS_DELETED', 0) ;
                    })
                    ->where('PTW_MST_CHECKLIST.IS_ACTIVE', 1)
                    ->where('PTW_MST_CHECKLIST.IS_DELETED', 0)
                    ->where('PTW_MST_CHECKLIST.CHECKLIST_TYPE',1)
                    ->where('PTW_MST_CHECKLIST.TYPE_ID', $type_id)
                    ->orderBy('PTW_MST_CHECKLIST.ORDER_NO')
                    ->get();
        }else{
            return PtwMstChecklist::select(
                'PTW_MST_CHECKLIST.CHECKLIST_ID', 
                'PTW_MST_CHECKLIST.CHECKLIST_NAME', 
                'PTW_MST_CHECKLIST.TYPE_ID', 
                'PTW_MST_CHECKLIST.IS_APPLICABLE_FOR_NIGHT',
                'PTW_MST_CHECKLIST.CHECKLIST_TYPE', 
                'PTW_MAP_CHECKLIST.MAP_CHECKLIST_ID',
                'PTW_MAP_CHECKLIST.OPTION_ID',
                'PTW_MAP_CHECKLIST.OPTION_NAME',
                'PTW_MAP_CHECKLIST.IS_ACTIVE',
                'PTW_MAP_CHECKLIST.IS_DELETED'
                )
                ->leftJoin('PTW_MAP_CHECKLIST', 'PTW_MST_CHECKLIST.CHECKLIST_ID', '=', 'PTW_MAP_CHECKLIST.CHECKLIST_ID')                            
                ->where('PTW_MAP_CHECKLIST.IS_ACTIVE', 1)
                ->where('PTW_MAP_CHECKLIST.IS_DELETED', 0)                            
                ->where("PTW_MAP_CHECKLIST.PTW_ID",$ptw_id)
                ->where('PTW_MST_CHECKLIST.CHECKLIST_TYPE',1)
                ->where('PTW_MST_CHECKLIST.TYPE_ID', $type_id)
                ->orderBy('PTW_MST_CHECKLIST.ORDER_NO')
                ->get();                  
        }       
    }

    public function getMapPpePtwCheckList($ptw_id,$type_id,$afterSubmit){
        if( $afterSubmit == 1 ){
            return PtwMstChecklist::select(
                        'PTW_MST_CHECKLIST.CHECKLIST_ID', 
                        'PTW_MST_CHECKLIST.CHECKLIST_NAME', 
                        'PTW_MST_CHECKLIST.TYPE_ID', 
                        'PTW_MST_CHECKLIST.IS_APPLICABLE_FOR_NIGHT',
                        'PTW_MST_CHECKLIST.CHECKLIST_TYPE', 
                        'PTW_MAP_CHECKLIST.MAP_CHECKLIST_ID',
                        'PTW_MAP_CHECKLIST.OPTION_ID',
                        'PTW_MAP_CHECKLIST.OPTION_NAME',
                        'PTW_MAP_CHECKLIST.IS_ACTIVE',
                        'PTW_MAP_CHECKLIST.IS_DELETED'
                    )
                    ->leftJoin('PTW_MAP_CHECKLIST', function($join) use ($ptw_id) {
                        $join->on('PTW_MST_CHECKLIST.CHECKLIST_ID', '=', 'PTW_MAP_CHECKLIST.CHECKLIST_ID')
                            ->where('PTW_MAP_CHECKLIST.PTW_ID', $ptw_id)
                            ->where('PTW_MAP_CHECKLIST.IS_ACTIVE', 1)
                            ->where('PTW_MAP_CHECKLIST.IS_DELETED', 0);
                    })
                    ->where('PTW_MST_CHECKLIST.IS_ACTIVE', 1)
                    ->where('PTW_MST_CHECKLIST.IS_DELETED', 0)                                    
                    ->where('PTW_MST_CHECKLIST.CHECKLIST_TYPE',2)
                    ->where('PTW_MST_CHECKLIST.TYPE_ID', $type_id)
                    ->orderBy('PTW_MST_CHECKLIST.ORDER_NO')
                    ->get();
        }else{
            return PtwMstChecklist::select(
                'PTW_MST_CHECKLIST.CHECKLIST_ID', 
                'PTW_MST_CHECKLIST.CHECKLIST_NAME', 
                'PTW_MST_CHECKLIST.TYPE_ID', 
                'PTW_MST_CHECKLIST.IS_APPLICABLE_FOR_NIGHT',
                'PTW_MST_CHECKLIST.CHECKLIST_TYPE', 
                'PTW_MAP_CHECKLIST.MAP_CHECKLIST_ID',
                'PTW_MAP_CHECKLIST.OPTION_ID',
                'PTW_MAP_CHECKLIST.OPTION_NAME',
                'PTW_MAP_CHECKLIST.IS_ACTIVE',
                'PTW_MAP_CHECKLIST.IS_DELETED'
                )
                ->leftJoin('PTW_MAP_CHECKLIST', 'PTW_MST_CHECKLIST.CHECKLIST_ID', '=', 'PTW_MAP_CHECKLIST.CHECKLIST_ID')                            
                ->where('PTW_MAP_CHECKLIST.IS_ACTIVE', 1)
                ->where('PTW_MAP_CHECKLIST.IS_DELETED', 0)                            
                ->where("PTW_MAP_CHECKLIST.PTW_ID",$ptw_id)
                ->where('PTW_MST_CHECKLIST.CHECKLIST_TYPE',2)
                ->where('PTW_MST_CHECKLIST.TYPE_ID', $type_id)
                ->orderBy('PTW_MST_CHECKLIST.ORDER_NO')
                ->get();                  
        }       
    }
    
}
