<?php

namespace App\Services\PTW;

use App\Http\Requests\PTW\AddRequest;
use App\Http\Resources\PTW\PtwResource;
use App\Models\MstSite;
use App\Models\PtwMstType;
use App\Models\MstLocation;
use App\Models\PtwMstContractor;
use App\Models\PtwMstSoapPolicies;
use App\Models\Hira;
use App\Models\PtwMstDeclaration;
use App\Models\PtwMstWorker;
use App\Models\Ptw;
use App\Models\User;
use App\Models\UserMapRole;

use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class PtwAuditServices extends PtwResource
{
    public $vvsPtwModel;
    public $page;
    public $pageSize;
    public function __construct()
    {
        $this->vvsPtwModel = new Ptw();
    }
    
    public function getPtwAuditDetails($requestData){        
        if (isset($requestData->SITE_ID)) {            
            $requestData->SITE = MstSite::where('SITE_ID',$requestData->SITE_ID)->pluck("SITE_NAME")->first();            
        }
        if (isset($requestData->TYPE_ID)) {            
            $requestData->TYPE = PtwMstType::where('TYPE_ID',$requestData->TYPE_ID)->pluck("TYPE_NAME")->first();            
        }
        if (isset($requestData->LOCATION_ID)) {            
            $requestData->LOCATION = MstLocation::where('LOCATION_ID',$requestData->LOCATION_ID)->pluck("LOCATION_NAME")->first();            
        }
        if (isset($requestData->CONTRACTOR_ID)) {            
            $requestData->CONTRACTOR =PtwMstContractor::where('CONTRACTOR_ID',$requestData->CONTRACTOR_ID)->pluck("CONTRACTOR_NAME")->first();            
        }
        if (isset($requestData->SOP_POLICY_ID)) {
            if (count($requestData->SOP_POLICY_ID)) {
                $requestData->SOP_POLICIES = PtwMstSoapPolicies::whereIn('SOP_POLICY_ID',$requestData->SOP_POLICY_ID)
                                            ->pluck("NAME");                
            }
        }
        if (isset($requestData->HIRA_REFERENCE_ID)) {
            if (count($requestData->HIRA_REFERENCE_ID)) {
                $requestData->HIRA_REFERENCES = Hira::whereIn('HIRA_ID',$requestData->HIRA_REFERENCE_ID)
                                            ->pluck("HIRA_REFERENCE_NO");
            }
        }
        if (isset($requestData->RISK)) {
            if (count($requestData->RISK)) {
                $requestData->RISKS = $this->getWorkerDetails($requestData->RISK);
            }
        }
        if (isset($requestData->DECLARATION_ID)) {
            if (count($requestData->DECLARATION_ID)) {
                $requestData->DECLARATIONS = PtwMstDeclaration::whereIn('DECLARATION_ID',$requestData->DECLARATION_ID)
                                            ->get(["DECLARATION_NAME","DECLARATION_SECTION","DECLARATION_GROUP",
                                            "IS_MANDATORY_DURING_ADD"]);
            }
        }

        return $requestData;
    }

    protected function getWorkerDetails($worker_ids) {
        return PtwMstWorker::select(
            'PTW_MST_WORKERS.WORKER_ID', 
            'PTW_MST_WORKERS.WORKER_NAME', 
            'PTW_MST_WORKERS.WORKER_DESG_ID', 
            'PTW_MST_WORKERS.WORKER_CONTRACTOR_ID',
            'PTW_MST_WORKERS.WORKER_AUTO_GEN_ID', 
            'PTW_MST_WORKER_DSG.WORKER_DESG_NAME',
            'PTW_MST_CONTRACTOR.CONTRACTOR_NAME'            
            )
            ->leftJoin('PTW_MST_WORKER_DSG', 'PTW_MST_WORKERS.WORKER_DESG_ID', '=', 'PTW_MST_WORKER_DSG.WORKER_DESG_ID')
            ->leftJoin('PTW_MST_CONTRACTOR', 'PTW_MST_WORKERS.WORKER_CONTRACTOR_ID', '=', 'PTW_MST_CONTRACTOR.CONTRACTOR_ID')                                  
            ->whereIn("PTW_MST_WORKERS.WORKER_ID",$worker_ids)            
            ->get();    
    }
}
