<?php

namespace App\Services\PTW;

use App\Http\Resources\PTW\PtwActionHistoryResource;
use App\Models\PtwActionHistory;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class PtwActionHistoryServices extends PtwActionHistoryResource
{
    public $vvsPtwActivityModel;
    public function __construct(){
        $this->vvsPtwActivityModel = new PtwActionHistory();
    }    
    

    public function getAllActivityLog($ptw_id){
        return PtwActionHistory::select(
            'PTW_ACTION_HISTORY.PTW_ID', 
            'PTW_ACTION_HISTORY.ACTION_TAKER_ID', 
            'PTW_ACTION_HISTORY.STAGE_ID', 
            'PTW_ACTION_HISTORY.COMMENTS',
            'PTW_ACTION_HISTORY.CREATED_BY', 
            'PTW_ACTION_HISTORY.CREATED_ON'           
        )
        ->leftJoin('PTW', function($join) use ($ptw_id) {
            $join->on('PTW.ID', '=', 'PTW_ACTION_HISTORY.PTW_ID')                
                ->where('PTW.IS_ACTIVE', 1)
                ->where('PTW.IS_DELETED', 0)
                ->where(function($query3) use ($ptw_id) {                   
                    $query3->where('PTW.ID', $ptw_id);
                    $query3->orWhere('PTW.TOP_PARENT_PTW_ID', $ptw_id);                    
                });
        })
        ->where('PTW_ACTION_HISTORY.IS_ACTIVE', 1)
        ->where('PTW_ACTION_HISTORY.IS_DELETED', 0)
        ->whereNotNull('PTW.ID')
        ->get();

    }
    
}
