<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\WorkmanListRequest;
use App\Http\Requests\Master\WorkmanAddRequest;
use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterWorkerServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterWorkerResource;
use App\Repositories\Master\MasterWorkerFileProcess;
use App\Models\UserMapRole;

class MasterWorkerRepository implements MasterWorkerInterface
{
    use EncDecService;
    public $vvsMasterWorkerService;
    public $vvsWorkmanListRequest;
    public $vvsWorkmanAddRequest;
    public $vvsUserService;

    /**
     * MasterWorkerRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterWorkerService = new MasterWorkerServices();
        $this->vvsWorkmanListRequest = new WorkmanListRequest();
        $this->vvsWorkmanAddRequest = new WorkmanAddRequest();
        $this->vvsUserService = new UserServices();
        $this->vvsWorkerFileProcess = new MasterWorkerFileProcess();
    }

    /**
     * @param Request $request
     * @return MasterWorkerResource
     */
    public function listWorker(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsWorkmanListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterWorkerData = $this->vvsMasterWorkerService->getMasterWorkerList($requestData);
                $masterWorkerTotalCount = $vvsMasterWorkerData['total'];
                 // Load the 'typeMappings.type' relationship
                $masterWorkerList = MasterWorkerResource::collection($vvsMasterWorkerData['data']->load('typeMappings.type'));
                
                $output = ["WORKER_LIST" => $masterWorkerList,"TOTAL_NO" => $masterWorkerTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterWorkerResource
     */
    public function workerAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);     
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $request->workerAddValidation();
            if (trim($validationErrorData) === "") {                
                $workerDataSaved = $this->vvsMasterWorkerService->workerSave($requestData);
                //return $this->successMessage("Worker (ID ".$workerDataSaved.") data has been saved.");
                return $this->successMessage($workerDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterWorkerResource
     */
    public function workerDetails(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }        
        try {
            $requestData = $this->customDecrypt($request->X_KEY);            
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {                
                $vvsWorkerData = $this->vvsMasterWorkerService->getWorkerDetails($requestData);                
                $vvsPtwMstWorkerTableOutput = MasterWorkerResource::transformWorker($vvsWorkerData);                
                $vvsPtwMstWorkerFileOutput = [
                    "WORKERS_FILES" => [
                        "EDITABLE"      => true,
                        "VALUE"         => $this->vvsWorkerFileProcess->getWorkerFiles($vvsWorkerData)
                    ]                    
                ];
                $vvsPtwOutput = array_merge($vvsPtwMstWorkerTableOutput, $vvsPtwMstWorkerFileOutput);
                return $this->successMessage($vvsPtwOutput);               
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}