<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PtwTypeMapWorkers extends Model
{
    use HasFactory;
    protected $primaryKey = 'MAP_WORKER_TYPE_ID';

    protected $table = 'PTWTYPE_MAP_WORKERS';
    public $timestamps = false;

    public $fillable = ["WORKER_ID","TYPE_ID","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function worker()
    {
        return $this->belongsTo(PtwMstWorker::class, 'WORKER_ID', 'WORKER_ID');
    }
    public function type()
    {
        return $this->belongsTo(PtwMstType::class, 'TYPE_ID', 'TYPE_ID');
    }
}
