<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PtwMstChecklist extends Model
{
    use HasFactory;
    protected $primaryKey = 'CHECKLIST_ID';

    protected $table = 'PTW_MST_CHECKLIST';
    public $timestamps = false;

    public $fillable = ["CHECKLIST_NAME","TYPE_ID","IS_APPLICABLE_FOR_NIGHT","CHECKLIST_TYPE","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function options()
    {
        return $this->hasMany(PtwMapChecklistOption::class, 'CHECKLIST_ID')->where('IS_DELETED', '=', 0);
    }
}
