<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ptw extends Model
{
    use HasFactory;
    protected $primaryKey = 'ID';

    protected $table = 'PTW';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';


    public $fillable = ["SITE_ID","AUTO_GEN_REF_NO","TYPE_ID","TOP_PARENT_PTW_ID","PARENT_PTW_ID",
                        "RENEWAL_COUNT","LOCATION_ID","PERMIT_START_TIME","PERMIT_END_TIME","DESCRIPTION",
                        "IS_CONTRACTOR_INFO_REQUIRED","CONTRACTOR_ID","IS_ISOLATION_REQUIRED","STAGE_ID",
                        "REMARKS","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON","CAPCHA_CODE","SPRINKLER_PROTECTION","SMOKE_DETECTION","ON_A_ROOF"];

    public function site()
    {
        return $this->belongsTo(MstSite::class, 'SITE_ID', 'SITE_ID');
    }

    public function type()
    {
        return $this->belongsTo(PtwMstType::class, 'TYPE_ID', 'TYPE_ID');
    }

    public function location()
    {
        return $this->belongsTo(MstLocation::class, 'LOCATION_ID', 'LOCATION_ID');
    }

    public function contractor()
    {
        return $this->belongsTo(PtwMstContractor::class, 'CONTRACTOR_ID', 'CONTRACTOR_ID');
    }

    public function stage()
    {
        return $this->belongsTo(PtwMstStage::class, 'STAGE_ID', 'STAGE_ID');
    }

    public function precausions()
    {
        return $this->hasMany(PtwMapPrecautions::class, 'PTW_ID')->where('IS_DELETED', 0);
    }

    public function checkLists()
    {
        return $this->hasMany(PtwMapChecklist::class, 'PTW_ID')->where('IS_DELETED', 0);
    }

    public function files()
    {
        return $this->hasMany(PtwMapFiles::class, 'PTW_ID')->where('IS_DELETED', 0);
    }

    public function sopPolicy()
    {
        return $this->hasMany(PtwMapSopPolicy::class, 'PTW_ID')->where('IS_DELETED', 0);
    }

    public function hira()
    {
        return $this->hasMany(PtwMapHira::class, 'PTW_ID')->where('IS_DELETED', 0);
    }

    public function workers()
    {
        return $this->hasMany(PtwMapWorkers::class, 'PTW_ID')->where('IS_DELETED', 0);
    }

    public function declarations()
    {
        return $this->hasMany(PtwMapDeclaration::class, 'PTW_ID')->where('IS_DELETED', 0);
    }

    public function generalcheckLists()
    {
        return $this->hasMany(PtwMapChecklist::class, 'PTW_ID')->where('IS_DELETED', '=', 0)->where('CHECKLIST_TYPE', '=', 1);
    }

    public function ppecheckLists()
    {
        return $this->hasMany(PtwMapChecklist::class, 'PTW_ID')->where('IS_DELETED', '=', 0)->where('CHECKLIST_TYPE', '=', 2);
    }

    public function actionHistory()
    {
        return $this->hasMany(PtwActionHistory::class, 'PTW_ID')->where('IS_DELETED', 0);
    }

    public function parent()
    {
        return $this->belongsTo(Ptw::class, 'ID', 'PARENT_PTW_ID');
    }

    public function topParent()
    {
        return $this->belongsTo(Ptw::class, 'ID', 'TOP_PARENT_PTW_ID');
    }

    public function actionRequestedHistory()
    {
        return $this->hasMany(PtwActionHistory::class, 'PTW_ID')->where('STAGE_ID', 2)->where('IS_DELETED', 0)->latest();
    }

    public function actionReviewedHistory()
    {
        return $this->hasMany(PtwActionHistory::class, 'PTW_ID')->where('STAGE_ID', 3)->where('IS_DELETED', 0)->latest();
    }

    public function actionApprovedHistory()
    {
        return $this->hasMany(PtwActionHistory::class, 'PTW_ID')->where('STAGE_ID', 5)->where('IS_DELETED', 0)->latest();
    }

    public function actionRejectedHistory()
    {
        return $this->hasMany(PtwActionHistory::class, 'PTW_ID')->where('STAGE_ID', 6)->where('IS_DELETED', 0)->latest();
    }

    public function actionClosedHistory()
    {
        return $this->hasMany(PtwActionHistory::class, 'PTW_ID')->where('STAGE_ID', 8)->where('IS_DELETED', 0)->latest();
    }

    public function actionSuspendedHistory()
    {
        return $this->hasMany(PtwActionHistory::class, 'PTW_ID')->where('STAGE_ID', 11)->where('IS_DELETED', 0)->latest();
    }
    
}
