<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PtwMapPrecReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $vvsPtwAction = [1=>"Tagged",2=>"Locked",3=>"Removed",4=>"Unlocked"];
        return [
            'TAG_NO'    => $this->TAG_NO,
            //'DEVICE'  => $this->DEVICE,
            'LOCATION'  => $this->LOCATION,
            'TAGGED_BY' => $this->taggedby->FIRST_NAME.' '.$this->taggedby->LAST_NAME,
            'TAGGED_ON' => ($this->TAGGED_ON != "") ? showDate($this->TAGGED_ON,"Y-m-d H:i:s") : "",
            'ACTION_ID' => $vvsPtwAction[$this->ACTION_ID] ?? ""
        ];
    }

    


}
