<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\PTW\PtwCheckListOptionResource;

class PtwMapCheckListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {        
        return [            
            'CHECKLIST_ID'      => $this->CHECKLIST_ID,
            'CHECKLIST_NAME'    => $this->CHECKLIST_NAME,
            'TYPE_ID'           => $this->TYPE_ID,
            'IS_APPLICABLE_FOR_NIGHT'=> $this->IS_APPLICABLE_FOR_NIGHT,
            'CHECKLIST_TYPE'=> $this->CHECKLIST_TYPE,
            'OPTION_ID'         => $this->OPTION_ID,
            'OPTIONS'           => PtwCheckListOptionResource::collection($this->options),
        ];
    }

    


}
