<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PtwActionHistoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'PTW_ID' => $this->PTW_ID,
            'ACTION' => $this->stage->STAGE_NAME,
            'ACTION_TAKEN_BY' => $this->actionTracker->FIRST_NAME.' '.$this->actionTracker->LAST_NAME,            
            'COMMENTS' => $this->COMMENTS,
            'ACTION_TAKEN_ON' => ($this->CREATED_ON != "") ? showDate($this->CREATED_ON,"Y-m-d H:i:s") : "",

        ];
    }
}
