<?php

namespace App\Http\Resources\Master;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MasterWorkerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'WORKER_ID'         => $this->WORKER_ID,
            'SITE_ID'           => $this->SITE_ID,
            'WORKER_NAME'       => $this->WORKER_NAME,
            'WORKER_AUTO_GEN_ID'       => $this->WORKER_AUTO_GEN_ID,
            'WORKER_DESG_NAME'  => $this->WORKER_DESG_NAME,
            'CONTRACTOR_NAME'   => $this->CONTRACTOR_NAME,
            'TYPE_NAME'         => $this->typeMappings->pluck('type.TYPE_NAME')->implode(','),
            'IS_EDIT_BTN'       => ($this->IS_ACTIVE == 0 && $this->typeMappings->count() == 0) ? true : false,
            'IS_DELETE_BTN'     => ($this->IS_ACTIVE == 0 && $this->typeMappings->count() == 0) ? true : false,
            'IS_APPROVE_BTN'    => ($this->IS_ACTIVE == 0 && $this->typeMappings->count() == 0) ? true : false,
            'IS_ACTIVE'         => $this->IS_ACTIVE,
            'IS_DELETED'        => $this->IS_DELETED,
        ];
    }

    public static function transformWorker($workerdetails, $action = null)
    {
        if (!isset($action)) {
            $action = "";
        }

        $editable = $workerdetails->IS_ACTIVE == 0 && $action !== 'view';

        return [
            'WORKER_ID' => ["EDITABLE" => false, "VALUE" => $workerdetails->WORKER_ID],
            'WORKER_AUTO_GEN_ID' => ["EDITABLE" => false, "VALUE" => $workerdetails->WORKER_AUTO_GEN_ID],
            'SITE_ID' => ["EDITABLE" => false, "VALUE" => $workerdetails->SITE_ID],
            'WORKER_NAME' => ["EDITABLE" => $editable, "VALUE" => $workerdetails->WORKER_NAME],
            'WORKER_DESG_ID' => ["EDITABLE" => $editable, "VALUE" => $workerdetails->WORKER_DESG_ID],
            'WORKER_CONTRACTOR_ID' => ["EDITABLE" => $editable, "VALUE" => $workerdetails->WORKER_CONTRACTOR_ID],
            'WORKER_COMPETENCY' => ["EDITABLE" => $editable, "VALUE" => $workerdetails->typeMappings->pluck('TYPE_ID')],            
        ];
    }
}
