<?php

namespace App\Http\Requests\PTW;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use App\Models\Ptw;
use App\Models\PtwMapChecklist;
use App\Models\PtwMapChecklistOption;
use App\Models\PtwMapDeclaration;
use App\Models\PtwMapSopPolicies;
use App\Models\PtwMapWorkers;
use App\Models\PtwMstDeclaration;
use App\Models\PtwMstSoapPolicies;
use App\Models\PtwMstWorker;
use App\Services\PTW\PtwServices;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class AddRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }

    protected function draftMandatoryFields($requestData)
    {

        $fields = ["SITE_ID", "TYPE_ID", "LOCATION_ID", "PERMIT_START_TIME", "PERMIT_END_TIME"];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank";
            }
        }
    }

    protected function draftCheckNumericFields($requestData)
    {
        $numericFields = ["SITE_ID", "TYPE_ID", "LOCATION_ID","CONTRACTOR_ID","IS_ISOLATION_REQUIRED"];

        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value";
            }
        }
    }

    private function validateDateTimeFormat($datetime)
    {
        return strtotime($datetime) !== false;
    }

    protected function validateSopPolicies($sopIds)
    {
        $error = "";

        if (isset($sopIds) && is_array($sopIds)) {
            $allSopData = PtwMstSoapPolicies::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                ->whereIn("SOP_POLICY_ID", $sopIds)->get();
            $data = $allSopData->toArray();
            if (count($data) != count($sopIds)) {
                $error = "Some of SOP & POLICY are not valid";
            }
        } else {
            $error = "SOP & POLICY Data are not valid";
        }
        return $error;
    }

    protected function validatePermitStartDateAndEndDate($requestedData)
    {
        $error = "";
        if (
            !$this->validateDateTimeFormat($requestedData->PERMIT_START_TIME)  ||
            !$this->validateDateTimeFormat($requestedData->PERMIT_END_TIME)
        ) {
            $error = "Permit Start Data / Permit End Date must be a valid date.";
        }
        if ($requestedData->PERMIT_START_TIME >= $requestedData->PERMIT_END_TIME) {
            $error = "Permit End Date must be bigger than Permit Start Date.";
        }
        // Validate time difference (12 hours)
        $startTime = new DateTime($requestedData->PERMIT_START_TIME);
        $endTime = new DateTime($requestedData->PERMIT_END_TIME);

        $timeDifference = $endTime->diff($startTime);

        // Check if the time difference is less than 12 hours
        if ($timeDifference->h > 12) {
            $error = "The time difference between Permit Start Date and Permit End Date must be less than 12 hours.";
        }
        return $error;
    }

    protected function checkStringFieldsWithSize($requestedData)
    {
        $error = "";
        $stringFieldsWithSize = [
            'DESCRIPTION' => 600,
            'REMARKS' => 600
        ];
        foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
            if (
                isset($requestedData->$stringKey) &&
                (!is_string($requestedData->$stringKey) || strlen($requestedData->$stringKey) > $stringValue)
            ) {
                $error = str_replace("_", " ", $stringKey) . " is expecting a string value with a maximum size of $stringValue";
            }
        }
        return $error;
    }

    protected function validatedContractorId($requestedData)
    {
        $error = "";

        if ($requestedData->IS_CONTRACTOR_INFO_REQUIRED == 0 && isset($requestedData->CONTRACTOR_ID)) {
            $error = "As contractor Information is not required so Contractor Name is not permitted.";
        } else {
           if($requestedData->ACTION == "SAVE"){
            if (!isset($requestedData->CONTRACTOR_ID)) {
                $error = "Contractor Name is required.";
            }
           } 
            if (!is_numeric(@$requestedData->CONTRACTOR_ID)) {
                $error = "Contractor Name is not valid.";
            }
        }
        return $error;
    }

    protected function validateWorkers($requestedData)
    {
        $siteId = $requestedData -> SITE_ID;
        $workerIds = $requestedData -> RISK;
        $workersInvalid = 0;
        $error = "";

        if($requestedData ->ID == 0){
            $permitStartTime = $requestedData ->PERMIT_START_TIME;
            $permitEndTime = $requestedData ->PERMIT_END_TIME;
        }else{
            $ptwData = Ptw::where("ID",$requestedData ->ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0)->first();
            $permitStartTime = $ptwData -> PERMIT_START_TIME;
            $permitEndTime = $ptwData -> PERMIT_END_TIME;
            $siteId = $ptwData -> SITE_ID;
        }

        
        
        if (isset($workerIds) && is_array($workerIds)) {
            $ptwService = new PtwServices();
            $workersInvalid = $ptwService -> workerExistsInPtwDuration($workerIds,$permitStartTime,$permitEndTime,$siteId);
            if( $workersInvalid > 0 ){
                $error = "Some of the workers are mapped with other PTW, please change the workers.";
            }else{
                $allWorkerData = PtwMstWorker::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("SITE_ID", $siteId)->whereIn("WORKER_ID", $workerIds)->get();
                $data = $allWorkerData->toArray();
                if (count($data) != count($workerIds)) {
                    $error = "Some of the Workers are not valid";
                }else{
                    //
                }
            }
        } else {
            $error = "Workers Data are not valid";
        }
        
        return $error;
    }
    protected function validateDeclaration($declarationIds, $ptwAddPage)
    {
        $error = "";

        if (isset($declarationIds) && is_array($declarationIds)) {
            if (isset($ptwAddPage) && $ptwAddPage == 1) {
                $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "PTW_ADD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
                    
            } elseif (isset($ptwAddPage) && $ptwAddPage == 2) {
                $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "PTW_MOVE_FORWARD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($ptwAddPage) && $ptwAddPage == 3) {
                $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "PTW_APPROVE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($ptwAddPage) && $ptwAddPage == 4) {
                $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "PTW_REJECT")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($ptwAddPage) && $ptwAddPage == 5) {
                $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "PTW_REQUEST_FOR_CLOSURE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($ptwAddPage) && $ptwAddPage == 6) {
                $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "PTW_CLOSE")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($ptwAddPage) && $ptwAddPage == 7) {
                $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "PTW_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            } elseif (isset($ptwAddPage) && $ptwAddPage == 8) {
                $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "PTW_REQUEST_FOR_SUSPEND")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            else {
                $allDeclarationData = PtwMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->whereNot("DECLARATION_GROUP", "PTW_ADD")->where("IS_MANDATORY_DURING_ADD", 1)
                    ->whereNotIn("DECLARATION_ID", $declarationIds)->pluck("DECLARATION_ID")->all();
            }
            $data = $allDeclarationData;
            if (count($data) != count($declarationIds)) {
                $error = "Some of the Declarations are not valid";
            }
        } else {
            $error = "Please check all the Declarations.";
        }
        return $error;
    }

    protected function validatePrecaution($requestedData)
    {
        $error = "";
        
        if (($requestedData->IS_ISOLATION_REQUIRED == 0) && isset($requestedData->PRECAUTIONS) && count($requestedData->PRECAUTIONS)) {
            $error = "As Isolation is not required so precaution is not permitted.";
        } else {
            if (!isset($requestedData->PRECAUTIONS) || count( @$requestedData->PRECAUTIONS ) == 0) {
                $error = "Precaution is required.";
            } elseif (!is_array($requestedData->PRECAUTIONS)) {
                $error = "Precaution is not valid.";
            } else {
                $precautionFieldCount = 5;

                foreach ($requestedData->PRECAUTIONS as $key => $value) {

                    $tagNo = $value->TAG_NO;
                    // $device = $value->DEVICE;
                    $activityLocation = $value->LOCATION;
                    $action = $value->ACTION_ID;
                    $taggedBy = $value->TAGGED_LOCKED_BY;
                    //$taggedOnArray = explode("/",$value->TAGGED_LOCKED_ON);
                    //$taggedOnDateRearrange =  $taggedOnArray[2]."-". $taggedOnArray[1]."-". $taggedOnArray[0];

                    $taggedOn = showDate($value->TAGGED_LOCKED_ON,'Y-m-d H:i:s');
                    // $taggedOn = DateTime::createFromFormat('Y-m-d', $value->TAGGED_ON);


                    // $precautionData = [$tagNo, $device, $activityLocation, $action, $taggedBy, $taggedOn];
                    $precautionData = [$tagNo,  $activityLocation, $action, $taggedBy, $taggedOn];
                    $precautionData  = array_filter($precautionData);
                   
                    if (count($precautionData) != $precautionFieldCount) {
                        $error = "Please check all the Precautions.";
                    } else {
                        $stringFieldsWithSize = [
                            'TAG_NO' => 15,
                            // 'DEVICE' => 50,
                            'LOCATION' => 50,
                        ];
                        foreach ($stringFieldsWithSize as $stringKey => $stringValue) {
                            if (
                                isset($requestedData->$stringKey) &&
                                (!is_string($requestedData->$stringKey) || strlen($requestedData->$stringKey) > $stringValue)
                            ) {
                                $error = str_replace("_", " ", $stringKey) . " in Precaution Section is expecting a
                                            string value with a maximum size of $stringValue";
                            }
                        }
                        //|| $taggedOn->format('Y-m-d') !== $value->TAGGED_ON

                        if (!is_numeric($action) || $action < 0) {
                            $error = "Action under Precaution Section is not a valid value.";
                        } elseif (!is_numeric($taggedBy) || $taggedBy <= 0) {
                            $error = "Tagged By under Precaution Section is not a valid value.";
                        } elseif (!$taggedOn ) {
                            $error = "The Tagged On field is not a valid date or does not match the format
                                     (YYYY-MM-DD) under Precaution Section.";
                        }
                    }
                }
            }
        }
        return $error;
    }

    protected function validateChecklist($requestData){
        $error = "";
        if (isset($requestData->GENERAL_CHECKLIST) && is_array($requestData->GENERAL_CHECKLIST)) {
            if(count($requestData->GENERAL_CHECKLIST)){
                foreach($requestData->GENERAL_CHECKLIST as $key => $value){
                    if($value->OPTION_ID != 999 || $value->CHECKLIST_ID != 999){
                        $checklistOptionData = PtwMapChecklistOption::where("CHECKLIST_ID",$value->CHECKLIST_ID)
                                                ->where("CHECKLIST_OPTION_ID",$value->OPTION_ID)
                                                ->where("IS_ACTIVE",1)
                                                ->where("IS_DELETED",0)->get();
                        if(count($checklistOptionData -> toArray()) == 0){
                            $error = "Checklist Data are not valid.";
                        }else{
                            $data = $checklistOptionData -> toArray();
                            if($data[0]["POSITIVITY"] == 0){
                                $error = "Upon thorough evaluation against safety checklist, it has been determined that your response does not meet the necessary criteria to proceed with the Permit to Work (PTW) submission. Compliance with all checklist points is mandatory before raising a PTW.";
                            }
                            //validation for checking night time checklist option
                        }
                    }
                    
                }
            }
        }elseif (isset($requestData->PPE_CHECKLIST) && is_array($requestData->PPE_CHECKLIST)) {
            if(count($requestData->PPE_CHECKLIST)){

                foreach($requestData->PPE_CHECKLIST as $key => $value){
                    if($value->OPTION_ID != 999 || $value->CHECKLIST_ID != 999){
                        $checklistOptionData = PtwMapChecklistOption::where("CHECKLIST_ID",$value->CHECKLIST_ID)->where("CHECKLIST_OPTION_ID",$value->OPTION_ID)
                                                ->where("IS_ACTIVE",1)->where("IS_DELETED",0)->get();
                        if(count($checklistOptionData -> toArray()) == 0){
                            $error = "Checklist Data are not valid.";
                        }else{
                            //validation for checking night time checklist option
                        }
                    }
                    
                }
            }
        } else {
            $error = "Checklist Data are not valid";
        }
        return $error;
    }


    protected function validateSprinklerProtection($requestedData){
        $error = "";
        if(isset( $requestedData-> SPRINKLER_PROTECTION)){
            if( $requestedData-> TYPE_ID != 2){
                $error = "SPRINKLER PROTECTION data is not valid for this type of PTW.";
            }
            else if( !is_numeric( $requestedData-> SPRINKLER_PROTECTION ) ){
                $error = "SPRINKLER PROTECTION data is not a valid data.";
            }
        }
        return $error;
    }
    protected function validateSmokeDetection($requestedData){
        $error = "";
        if(isset( $requestedData-> SMOKE_DETECTION)){
            if( $requestedData-> TYPE_ID != 2){
                $error = "SMOKE DETECTION data is not valid for this type of PTW.";
            }
            else if( !is_numeric( $requestedData-> SMOKE_DETECTION ) ){
                $error = "SMOKE DETECTION data is not a valid data.";
            }
        }
        return $error;
    }
    protected function validateOnARoof($requestedData){
        $error = "";
        if(isset( $requestedData-> ON_A_ROOF)){
            if( $requestedData-> TYPE_ID != 2){
                $error = "ON ROOF data is not valid for this type of PTW.";
            }
            else if( !is_numeric( $requestedData-> ON_A_ROOF ) ){
                $error = "ON ROOF data is not a valid data.";
            }
        }
        return $error;
    }
    public function ptwAddValidation()
    {
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);
       
        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "DRAFT";

        if (!in_array($action, ["DRAFT", "SAVE","RENEW"])) {
            return "Please mention the type of activity in terms of ACTION.";
        }
        
        $error = $this->draftMandatoryFields($requestedData) ?:
            $this->draftCheckNumericFields($requestedData) ?:
            $this->checkStringFieldsWithSize($requestedData);

        if ($error) {
            return $error;
        }

        //if renew then need to send PARENT_PTW_ID
        if( isset($requestedData -> PARENT_PTW_ID) ){
            if(!is_numeric($requestedData -> PARENT_PTW_ID)){
                $error = "Parent PTW is not a valid ID.";
            }
        }
        

        //permit start date and end date validation
        $error = $this->validatePermitStartDateAndEndDate($requestedData);
        if ($error) {
            return $error;
        }

        //other optional fields validation

        //SOP policy field validation
        if (isset($requestedData->SOP_POLICY_ID) && count($requestedData->SOP_POLICY_ID)) {
            $error = $this->validateSopPolicies($requestedData->SOP_POLICY_ID);
        }
        if ($error) {
            return $error;
        }


        //contractor name validation
        if (isset($requestedData->IS_CONTRACTOR_INFO_REQUIRED)) {
            $error = $this->validatedContractorId($requestedData);
        }
        if ($error) {
            return $error;
        }


        //worker validation

        if (isset($requestedData->RISK) && count( $requestedData->RISK )) {
            $error = $this->validateWorkers($requestedData);
        }
        if ($error) {
            return $error;
        }

        //declaration validation
       
        if (isset($requestedData->DECLARATION_ID)  && count( $requestedData->DECLARATION_ID )) {
            $error = $this->validateDeclaration($requestedData->DECLARATION_ID, 1);
        }
        if ($error) {
            return $error;
        }
        
        if (isset($requestedData->IS_ISOLATION_REQUIRED) && $requestedData->IS_ISOLATION_REQUIRED == 1) {
            $error = $this->validatePrecaution($requestedData);
        }
        if ($error) {
            return $error;
        }
        if (isset($requestedData->GENERAL_CHECKLIST) || isset($requestedData->PPE_CHECKLIST)) {
            $error = $this->validateChecklist($requestedData);
        }
        if ($error) {
            return $error;
        }
        if (isset($requestedData->SPRINKLER_PROTECTION) ) {
            $error = $this->validateSprinklerProtection($requestedData);
        }
        if ($error) {
            return $error;
        }
        
        if (isset($requestedData->SMOKE_DETECTION) ) {
            $error = $this->validateSmokeDetection($requestedData);
        }
        if ($error) {
            return $error;
        }
        if (isset($requestedData->ON_A_ROOF) ) {
            $error = $this->validateOnARoof($requestedData);
        }
        if ($error) {
            return $error;
        }

        if (in_array($action, ["SAVE"])) {
            if($requestedData -> ID == 0 ){
                if(
                    !isset($requestedData->SOP_POLICY_ID) ||
                    !isset($requestedData->IS_CONTRACTOR_INFO_REQUIRED) ||
                    !isset($requestedData->RISK) ||
                    !isset($requestedData->DECLARATION_ID) ||
                    !isset($requestedData->IS_ISOLATION_REQUIRED) ||
                    !isset($requestedData->GENERAL_CHECKLIST)||
                    !isset($requestedData->PPE_CHECKLIST)
                ){
                    $error = "Please provide all the required fields." ;
                }
                if($requestedData-> TYPE_ID == 2 ){
                    if(
                        !isset($requestedData->SPRINKLER_PROTECTION) ||
                        !isset($requestedData->SMOKE_DETECTION) ||
                        !isset($requestedData->ON_A_ROOF)
                    ){
                        $error = "Please provide all the required fields." ; 
                    }
                }
            }
            // else{
            //     $sopExists = PtwMapSopPolicies::where("PTW_ID",$requestedData->ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0);
            //     $contractorIsolationInfoExists = Ptw::where("ID",$requestedData->ID)->whereNotNull("IS_CONTRACTOR_INFO_REQUIRED")
            //                                                     ->whereNotNull("IS_ISOLATION_REQUIRED")
            //                                                     ->where("IS_ACTIVE",1)->where("IS_DELETED",0);
            //     $workerExists = PtwMapWorkers::where("PTW_ID",$requestedData->ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0);    
            //     $declarationExists = PtwMapDeclaration::where("PTW_ID",$requestedData->ID)->where("IS_ACTIVE",1)->where("IS_DELETED",0);
            //     $generalChecklistExists = PtwMapChecklist::where("PTW_ID",$requestedData->ID)->where("CHECKLIST_TYPE",1)->where("IS_ACTIVE",1)
            //                                 ->where("IS_DELETED",0);
            //     $ppeChecklistExists = PtwMapChecklist::where("PTW_ID",$requestedData->ID)->where("CHECKLIST_TYPE",2)
            //                                 ->where("IS_ACTIVE",1)->where("IS_DELETED",0);
               

            //     if( 
            //         !$sopExists ->exists() || !$contractorIsolationInfoExists -> exists() || !$workerExists -> exists() ||
            //         !$declarationExists->exists() || !$generalChecklistExists -> exists() || !$ppeChecklistExists -> exists()||
            //         !isset($requestedData->SOP_POLICY_ID) ||
            //         !isset($requestedData->IS_CONTRACTOR_INFO_REQUIRED) ||
            //         !isset($requestedData->RISK) ||
            //         !isset($requestedData->DECLARATION_ID) ||
            //         !isset($requestedData->IS_ISOLATION_REQUIRED) ||
            //         !isset($requestedData->GENERAL_CHECKLIST)||
            //         !isset($requestedData->PPE_CHECKLIST)

            //     ){
            //         $error = "Please provide all the required fields." ;
            //     }

            // }
        }


        return $error;
    }

    public function validateCaptcha($requestedData){
        $ptwId = $requestedData -> ID;
        $captchaCode = $requestedData -> CAPTCHA_CODE;
        $error = "";  
        if( !isset($captchaCode) || $captchaCode == "" ){
            $error = "Please provide Captcha Code.";
        }else{
            $ptwCaptchaCheck = Ptw::where("ID",$ptwId)->where("CAPTCHA_CODE",$captchaCode)->first();
            if(empty($ptwCaptchaCheck)){
                $error = "Captcha Code is not valid.";
            }
        }
        return $error;
       
    }

    public function getDeclarationSectionbyAction($action){
        $declarationSection = 0;
        if ($action == "DRAFT"){
            $declarationSection = 1;
        }
        elseif ($action == "MOVE_FORWARD"){
            $declarationSection = 2;
        }
        elseif ($action == "APPROVE"){
            $declarationSection = 3;
        }
        elseif ($action == "REJECT"){
            $declarationSection = 4;
        }
        elseif ($action == "REQUEST_FOR_CLOSURE"){
            $declarationSection = 5;
        }
        elseif ($action == "CLOSE"){
            $declarationSection = 6;
        }
        elseif ($action == "SUSPEND"){
            $declarationSection = 7;
        }
        elseif ($action == "REQUEST_FOR_SUSPEND"){
            $declarationSection = 8;
        }
        return $declarationSection;
    }
    public function ptwSaveValidation()
    {
        $error = "";
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        $requestedData = objectFilter($requestedData);

        $action = isset($requestedData->ACTION) ? strtoupper($requestedData->ACTION) : "";

        if (!in_array($action, ["MOVE_FORWARD","SEND_BACK","APPROVE","REJECT","REQUEST_FOR_CLOSURE","REQUEST_FOR_SUSPEND","CLOSE","SUSPEND"])) {
            $error = "Please mention the type of activity in terms of ACTION.";
        }

        if (empty($requestedData->ID)) {
            $error = "PTW Id should not be blank.";
        }
        if (!is_numeric($requestedData->ID)) {
            $error = "PTW Id should is not a valid number.";
        }



        if ($error) {
            return $error;
        }

        $declarationSection = $this->getDeclarationSectionbyAction($action);
        
        //declaration validation
        if (isset($requestedData->DECLARATION_ID)) {
            $error = $this->validateDeclaration($requestedData->DECLARATION_ID, $declarationSection);
        }

        if($requestedData -> ACTION == "CLOSE"){
            $error = $this -> validateCaptcha($requestedData);
            
        } 

        return $error;
    }


    public function ptwCheckListData($ptwId, $creator)
    {
        $vvsPtwChkListData = [];
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        if (count($requestedData->GENERAL_CHECKLIST)) {
            foreach ($requestedData->GENERAL_CHECKLIST as $vvsPtwChGen) {
                $vvsPtwChkListData[] = [
                    'PTW_ID'      => $ptwId,
                    'CHECKLIST_ID'      => $vvsPtwChGen->CHECKLIST_ID,
                    'OPTION_ID'      => $vvsPtwChGen->OPTION_ID,
                    'CHECKLIST_NAME'    => $vvsPtwChGen->CHECKLIST_NAME,
                    'OPTION_NAME'   => $vvsPtwChGen->OPTION_NAME,
                    'CREATED_BY'  => $creator
                ];
            }
        }
        if (count($requestedData->PPE_CHECKLIST)) {
            foreach ($requestedData->PPE_CHECKLIST as $vvsPtwChPpe) {
                $vvsPtwChkListData[] = [
                    'PTW_ID'      => $ptwId,
                    'CHECKLIST_ID'      => $vvsPtwChPpe->CHECKLIST_ID,
                    'OPTION_ID'      => $vvsPtwChPpe->OPTION_ID,
                    'CHECKLIST_NAME'    => $vvsPtwChPpe->CHECKLIST_NAME,
                    'OPTION_NAME'   => $vvsPtwChPpe->OPTION_NAME,
                    'CREATED_BY'  => $creator
                ];
            }
        }

        return $vvsPtwChkListData;
    }

    public function ptwWorkerData($ptwId, $creator)
    {
        $vvsPtwWorkerData = [];
        $requestedData = $this->customDecrypt($this->input('X_KEY'));
        if (count($requestedData->RISK)) {
            foreach ($requestedData->RISK as $vvsPtwRisk) {
                $vvsPtwWorkerData[] = [
                    'PTW_ID'      => $ptwId,
                    'WORKER_ID'   => $vvsPtwRisk->WORKER_ID,
                    'CREATED_BY'  => $creator
                ];
            }
        }
        return $vvsPtwWorkerData;
    }
}
