<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PtwMstType;
use App\Repositories\PTW\PtwInterface;
use App\Http\Traits\InvalidTokenCheck;
use App\Http\Requests\PTW\AddRequest;
use Illuminate\Support\Facades\File;





class PtwControllerV1 extends Controller
{
    use InvalidTokenCheck;
    private $repository;

    public function __construct(PtwInterface $repository){
        $this->repository = $repository;
    }
    
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return response()->json(PtwMstType::all());   
    }

    /**
     * Store a newly created resource in storage.
     */
    public function ptwList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listPtw($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function ptwDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->ptwDetails($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function ptwAdd(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->ptwAdd($request);
    }

    public function createCaptcha(Request $request){
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->createCaptcha($request);       
        
    }

    /**
     * Store a newly created resource in storage.
     */
    public function ptwDownloadableList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->ptwDownloadableList($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function ptwDetailsExport(Request $request)
    {        
        return $this->repository->ptwDetailsExport($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function ptwActivityLog(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->ptwActivityLog($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function ptwAudit(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->ptwAudit($request);
    }

}
