<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PtwMstType;
use App\Repositories\Master\MasterWorkerInterface;
use App\Http\Requests\Master\WorkmanAddRequest;
use App\Http\Traits\InvalidTokenCheck;

class MasterWorkerControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(MasterWorkerInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function workerList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listWorker($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function workerAdd(WorkmanAddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->workerAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function workerDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->workerDetails($request);
    }
}
