<?php
use Illuminate\Support\Facades\Cache;

function pr($data)
{
  echo "<pre>";
  print_r($data);
  echo "</pre>";
}

function prd($data)
{
  echo "<pre>";
  print_r($data);
  echo "</pre>";
  die;
}


function errorResponse($message){
  return response()->json([
            'Message'=>$message,
            'Status'=>400,
            'Type'=>'Error'
        ]);
}
function successResponse($message) {
  return response()->json([
            'Message'=>$message,
            'Status'=>200,
            'Type'=>'Success'
        ]);
}

/**
   * DB query with binding values
   * $query : String | it is a query string with `?` letter
   * $bindings : Array | array of values for every `?` letter
   */
function getQueryWithBindings($query,$bindings){
    return vsprintf(str_replace('?', '%s', $query), collect($bindings)->map(function ($binding) {
        $binding = addslashes($binding);
        return is_numeric($binding) ? $binding : "'{$binding}'";
    })->toArray());
}

function showDate($date, $format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d";

  // Convert string date to Carbon instance if it's not already
  $carbonDate = is_string($date) ? Carbon\Carbon::parse($date) : $date;

  return $carbonDate->setTimezone($timeZone)->format($format);
}

function convertSlashDate($date, $format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d";

  // Parse the date string using the specified format
  $carbonDate = Carbon\Carbon::createFromFormat('d/m/Y', $date);

  // Set the timezone and format the date
  return $carbonDate->setTimezone($timeZone)->format($format);

}

function currentDateTime($format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d H:i:s";
  return showDate(date($format),$format,$timeZone);
}

function currentDateTimeAddSubtract1($interval,$format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d H:i:s";
  $date = new DateTime(showDate(date($format), $format, $timeZone));
  $date->modify($interval);
  return showDate(date($format),$format,$timeZone);
}

function currentDateTimeAddSubtract($interval, $format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d H:i:s";
  
  // Create a Carbon instance representing the current date and time
  $carbonDate = Carbon\Carbon::now($timeZone);

  // Modify the date by adding or subtracting the given interval
  $carbonDate->modify($interval);

  // Return the modified date in the specified format and timezone
  return showDate($carbonDate, $format, $timeZone);
}

function createSlashDate($date, $format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d";
  $datearr = explode(" ", $date);

  // Parse the date string using the specified format
  $carbonDate = Carbon\Carbon::createFromFormat('Y-m-d H:i:s', Carbon\Carbon::parse($datearr[0])->format('Y-m-d') . " " . $datearr[1]);

  // Set the timezone and format the date
  return $carbonDate->setTimezone($timeZone)->format($format);

}

function objectFilter($object){
  foreach ($object as $key => $value) {
    // Check if the value is empty
    if (($value) == "") {
        // Remove the property from the object
        unset($object->$key);
    }
  }
  return $object;
}

function getPrecautionActionList(){
  $preType = array();
  $preType[] = array('KEY'=>1, 'VALUE'=>'Tagged');
  $preType[] = array('KEY'=>2, 'VALUE'=>'Locked');
  //$preType[] = array('KEY'=>3, 'VALUE'=>'Removed');
  //$preType[] = array('KEY'=>4, 'VALUE'=>'Unlocked');
  return $preType;
}


function typeIdTextMapping(){
  return [
      1=>"CP",
      2=>"HW",
      3=>"WAH",
      4=>"EW"
  ];
}
function ordinalConversion($number) {
  $suffix = ['th', 'st', 'nd', 'rd', 'th', 'th', 'th', 'th', 'th', 'th'];
  if (($number % 100) >= 11 && ($number % 100) <= 13) {
      return $number . 'th';
  } else {
      return $number . $suffix[$number % 10];
  }
}
