<?php

use App\Http\Controllers\Api\AuthControllerV1;
use App\Http\Controllers\Api\EncDecController;
use App\Http\Controllers\Api\FileControllerV1;
use App\Http\Controllers\Api\PtwControllerV1;
use App\Http\Controllers\Api\PtwMasterListControllerV1;
use App\Http\Controllers\Api\MasterWorkerControllerV1;
use App\Http\Controllers\Api\HiraControllerV1;
use App\Http\Controllers\Api\HiraMasterListControllerV1;
use App\Http\Controllers\Api\InspectionMasterListControllerV1;
use App\Http\Controllers\Api\InspectionControllerV1;
use App\Http\Controllers\Api\MasterLocationControllerV1;
use App\Http\Controllers\Api\ObservationMasterListControllerV1;
use App\Http\Controllers\Api\TrainingMasterListControllerV1;
use App\Http\Controllers\Api\TrainingControllerV1;
use App\Http\Controllers\Api\ObservationControllerV1;
use App\Http\Controllers\Api\MasterContractorControllerV1;
use App\Http\Controllers\Api\MasterSkillControllerV1;
use App\Http\Controllers\Api\MasterSOPPolicyControllerV1;
use App\Http\Controllers\Api\MasterUserAccessControllerV1;
use App\Http\Controllers\Api\MasterJobControllerV1;
use App\Http\Controllers\Api\MasterActivityControllerV1;
use App\Http\Controllers\Api\MasterRiskRelatedControllerV1;
use App\Http\Controllers\Api\ReportPtwControllerV1;
use App\Http\Controllers\Api\ReportHiraControllerV1;
use App\Http\Controllers\Api\ReportObservationControllerV1;
use App\Http\Controllers\Api\ReportInspectionControllerV1;
use App\Http\Controllers\Api\MasterTypeTopicControllerV1;
use App\Http\Controllers\Api\DashboardPtwControllerV1;
use App\Http\Controllers\Api\SamlUserControllerV1;
use App\Http\Controllers\Api\DashboardHiraControllerV1;
use App\Http\Controllers\Api\DashboardTrainingControllerV1;
use App\Http\Controllers\Api\DashboardObservationControllerV1;
use App\Http\Controllers\Api\DashboardInspectionControllerV1;
use App\Http\Controllers\Api\UserAclMapControllerV1;

use App\Http\Controllers\Api\ChartPtwControllerV1;
use App\Http\Controllers\Api\ChartHiraControllerV1;
use App\Http\Controllers\Api\ChartObservationControllerV1;
use App\Http\Controllers\Api\ChartInspectionControllerV1;


use App\Http\Controllers\Api\ReportTrainingControllerV1;
use App\Http\Controllers\DateController;
use App\Http\Controllers\SystemController;
use Illuminate\Support\Facades\Route;



/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::get('cc', [SystemController::class, 'cc']);
Route::get('mg', [SystemController::class, 'mg']);
Route::get('prgtab', [SystemController::class, 'removeAllTables']);

Route::post('DataEnc', [EncDecController::class, 'dataEncryption']);
Route::post('DataDec', [EncDecController::class, 'dataDecryption']);

Route::get('ServerDate',[DateController::class, 'index']);
Route::post('ServerDate',[DateController::class, 'index']);
Route::post('SamlUserUpdate',[SamlUserControllerV1::class, 'updateUser']);

Route::prefix('v1')->group(function () {
   Route::post('login', [AuthControllerV1 ::class, 'login']);
   Route::post('FileUpload', [FileControllerV1 ::class, 'fileupload']);
   //should be under sanctum middleware and it will be implemented after proper login
    Route::group(['middleware' => ['XssSanitizer']], function () {
        Route::controller(PtwControllerV1::class)->group(function() {
            Route::get('ptw', 'index');
            Route::post('Ptw/GetPtwList', 'ptwList');
            Route::post('Ptw/GetPtwDetails', 'ptwDetails');
            Route::post('Ptw/AddPtw', 'ptwAdd');
            Route::post('Ptw/CaptchaGenerate', 'createCaptcha');
            Route::post('Ptw/GetPtwDownloadableList', 'ptwDownloadableList');
            Route::post('Ptw/GetDetailsReport', 'ptwDetailsExport');
            Route::post('Ptw/GetActivityLog', 'ptwActivityLog');
            Route::post('Ptw/GetPtwAudit', 'ptwAudit');
        });
        Route::controller(PtwMasterListControllerV1::class)->group(function() {
            Route::post('Ptw/GetPtwMaster', 'masterListPtw');
            Route::post('Ptw/GetPtwMasterCheckList', 'masterChekListPtw');
        });
        Route::controller(MasterWorkerControllerV1::class)->group(function() {
            Route::post('Master/GetWorkerList', 'workerList');
            Route::post('Master/AddWorker', 'workerAdd');
            Route::post('Master/GetWorkerDetails', 'workerDetails');
        });
        Route::controller(HiraControllerV1::class)->group(function() {
            Route::get('hira', 'index');
            Route::post('Hira/GetHiraList', 'hiraList');
            Route::post('Hira/GetHiraInfo', 'hiraDetails');
            Route::post('Hira/AddHira', 'hiraAdd');
            Route::post('Hira/AddHiraInfo', 'hiraAddInfo');
            Route::post('Hira/GetActivityLog', 'hiraActivityLog');
            Route::post('Hira/GetDetailsReport', 'hiraDetailsExport');
            Route::post('Hira/AddHiraACM', 'hiraAddAcm');
            Route::post('Hira/GetHiraDownloadableList', 'hiraDownloadableList');
            Route::post('Hira/GetHiraActivityLog', 'hiraWiseLog');
            Route::post('Hira/AddDeclarationM', 'hiraAddDeclarationM');
        });
        Route::controller(HiraMasterListControllerV1::class)->group(function() {
            Route::post('Hira/GetHiraMaster', 'masterListHira');
        });
        Route::controller(InspectionMasterListControllerV1::class)->group(function() {
            Route::post('Inspection/GetInspectionMaster', 'masterListInspection');
            Route::post('Inspection/GetInspectionMasterCheckList', 'masterChekListInspection');
        });
        Route::controller(InspectionControllerV1::class)->group(function() {
            Route::post('Inspection/GetInspectionList', 'inspectionList');
            Route::post('Inspection/AddInspection', 'inspectionAdd');
            Route::post('Inspection/GetInspectionDetails', 'inspectionDetails');
            Route::post('Inspection/GetActivityLog', 'inspectionActivityLog');
            Route::post('Inspection/GetInspectionDownloadableList', 'inspectionDownloadableList');
            Route::post('Inspection/GetDetailsReport', 'inspectionDetailsExport');
        }); 
        Route::controller(MasterLocationControllerV1::class)->group(function() {
            Route::post('Master/GetLocationList', 'locationList');
            Route::post('Master/AddLocation', 'locationAdd');
            Route::post('Master/GetLocationDetails', 'locationDetails');
        });
        Route::controller(ObservationMasterListControllerV1::class)->group(function() {
            Route::post('Observation/GetObservationMaster', 'masterListObservation');
            
        });
        Route::controller(MasterContractorControllerV1::class)->group(function() {
            Route::post('Master/GetContractorList', 'contractorList');
            Route::post('Master/AddContractor', 'contractorAdd');
            Route::post('Master/GetContractorDetails', 'contractorDetails');
        });
        Route::controller(ObservationControllerV1::class)->group(function() {
            Route::post('Observation/GetObservationList', 'observationList');
            Route::post('Observation/GetObservationDetails', 'observationDetails');
            Route::post('Observation/AddObservation', 'observationAdd');
            Route::post('Observation/GetDetailsReport', 'observationDetailsExport');
            Route::post('Observation/GetObservationDownloadableList', 'observationDownloadableList');
            Route::post('Observation/GetObservationCommentLog', 'commentLog');
            Route::post('Observation/GetObservationActionTakenLog', 'actionTakenLog');
            Route::post('Observation/AddDeclarationM', 'obsAddDeclarationM');
        });
        Route::controller(MasterSkillControllerV1::class)->group(function() {
            Route::post('Master/GetSkillList', 'skillList');
            Route::post('Master/AddSkill', 'skillAdd');
            Route::post('Master/GetSkillDetails', 'skillDetails');
        });
        Route::controller(MasterSOPPolicyControllerV1::class)->group(function() {
            Route::post('Master/GetSOPPolicyList', 'sopPolicyList');
            Route::post('Master/AddSOPPolicy', 'sopPolicyAdd');
            Route::post('Master/GetSOPPolicyDetails', 'sopPolicyDetails');
        });
        Route::controller(MasterUserAccessControllerV1::class)->group(function() {
            Route::post('Master/GetUserAccessList', 'userAccessList');
            Route::post('Master/AddUserAccess', 'userAccessAdd');
            Route::post('Master/GetUserAccessDetails', 'userAccessDetails');
            Route::post('Master/GetUserAccessMasterList', 'userAccessMasterList');
        });
        Route::controller(TrainingMasterListControllerV1::class)->group(function() {
            Route::post('Training/GetTrainingMaster', 'masterListTraining');
            
        });
        Route::controller(TrainingControllerV1::class)->group(function() {
            Route::post('Training/AddTraining', 'trainingAdd');
            Route::post('Training/GetTrainingDetails', 'trainingDetails');
            Route::post('Training/GetTraininglist', 'trainingList');
            Route::post('Training/GetTraininglistCal', 'trainingListCal');
            Route::post('Training/GetTraininglistOnDemand', 'trainingListOnDemand');
            Route::post('Training/AddTrainingCal', 'trainingAddCal');
            Route::post('Training/GetDetailsReport', 'trainingDetailsExport');
        });
        Route::controller(MasterJobControllerV1::class)->group(function() {
            Route::post('Master/GetJobList', 'jobList');
            Route::post('Master/AddJob', 'jobAdd');
            Route::post('Master/GetJobDetails', 'jobDetails');
        });
        Route::controller(MasterActivityControllerV1::class)->group(function() {
            Route::post('Master/GetActivityList', 'activityList');
            Route::post('Master/AddActivity', 'activityAdd');
            Route::post('Master/GetActivityDetails', 'activityDetails');
        });
        Route::controller(MasterRiskRelatedControllerV1::class)->group(function() {
            Route::post('Master/GetRiskRelatedList', 'riskRelatedList');
            Route::post('Master/AddRiskRelated', 'riskRelatedAdd');
            Route::post('Master/GetRiskRelatedDetails', 'riskRelatedDetails');
        });
        Route::controller(ReportPtwControllerV1::class)->group(function() {
            Route::post('Report/GetPtwListReport', 'ptwListReport');
        });
        Route::controller(ReportHiraControllerV1::class)->group(function() {
            Route::post('Report/GetHiraListReport', 'hiraListReport');
        });
        Route::controller(ReportObservationControllerV1::class)->group(function() {
            Route::post('Report/GetObservationListReport', 'observationListReport');
        });
        Route::controller(ReportInspectionControllerV1::class)->group(function() {
            Route::post('Report/GetInspectionListReport', 'inspectionListReport');
        });
        Route::controller(MasterTypeTopicControllerV1::class)->group(function() {
            Route::post('Master/GetTypeTopicList', 'typeTopicList');
            Route::post('Master/AddTypeTopic', 'typeTopicAdd');
            Route::post('Master/GetTypeTopicDetails', 'typeTopicDetails');
        });
        Route::controller(DashboardPtwControllerV1::class)->group(function() {
            Route::post('Dashboard/GetDashboardPtwCounts', 'dashboardPtwCounts');
        });
        Route::controller(DashboardHiraControllerV1::class)->group(function() {
            Route::post('Dashboard/GetDashboardHiraCounts', 'dashboardHiraCounts');
        });
        Route::controller(DashboardTrainingControllerV1::class)->group(function() {
            Route::post('Dashboard/GetDashboardTrainingCounts', 'dashboardTrainingCounts');
        });
        Route::controller(DashboardObservationControllerV1::class)->group(function() {
            Route::post('Dashboard/GetDashboardObservationCounts', 'dashboardObservationCounts');
        });
        Route::controller(DashboardInspectionControllerV1::class)->group(function() {
            Route::post('Dashboard/GetDashboardInspectionCounts', 'dashboardInspectionCounts');
        });
        Route::controller(UserAclMapControllerV1::class)->group(function() {
            Route::post('UserAcl/GetUserMenuList', 'userMenuList');
        });
        Route::controller(ReportTrainingControllerV1::class)->group(function() {
            Route::post('Report/GetTrainingListReport', 'trainingListReport');
        });
        Route::controller(ChartPtwControllerV1::class)->group(function() {
            Route::post('Chart/GetChartPtwCounts', 'chartPtwCounts');
        });
        Route::controller(ChartHiraControllerV1::class)->group(function() {
            Route::post('Chart/GetChartHiraCounts', 'chartHiraCounts');
        });
        Route::controller(ChartObservationControllerV1::class)->group(function() {
            Route::post('Chart/GetChartObservationCounts', 'chartObservationCounts');
        });
        Route::controller(ChartInspectionControllerV1::class)->group(function() {
            Route::post('Chart/GetChartInspectionCounts', 'chartInspectionCounts');
        });
    });
});


