<?php

namespace Database\Seeders;

use App\Models\MstRole;
use App\Models\UserMapRole;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UserMapRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        UserMapRole::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $roleIds = MstRole::pluck('ROLE_ID')->all();
       
 
        for ($i = 0; $i < 20; $i++) {
            UserMapRole::create([
                "USER_ID" => $userIds[array_rand($userIds)],
                "ROLE_ID" => $roleIds[array_rand($roleIds)],
                "ROLE_NAME" => $vvsFaker->word,
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
