<?php

namespace Database\Seeders;

use App\Models\UserLoginHistory;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UserLoginHistorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        UserLoginHistory::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
       
 
        for ($i = 0; $i < 50; $i++) {
            UserLoginHistory::create([
                "USER_ID" => $userIds[array_rand($userIds)],
                "LOGIN_TIME" => $vvsFaker->dateTime,
                "LOGOUT_TIME" => $vvsFaker->dateTime,
                "IP_ADDRESS" => $vvsFaker->ipv4,
                "BROWSER_AGENT" => $vvsFaker->userAgent,
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
