<?php

namespace Database\Seeders;

use App\Models\UserLogModification;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UserLogModificationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        UserLogModification::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
       
 
        for ($i = 0; $i < 50; $i++) {
            UserLogModification::create([
                "USER_ID" => $userIds[array_rand($userIds)],
                "DEMAND_NO" => $vvsFaker->word,
                "OLD_VALUE" => $vvsFaker->paragraph,
                "NEW_VALUE" => $vvsFaker->paragraph,
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
