<?php

namespace Database\Seeders;

use App\Models\PtwMstType;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //lets truncate the existing records
        PtwMstType::truncate();
		$userIds = User::pluck('ID')->all();

        $vvsFaker = \Faker\Factory::create();
        // And now, let's create a few PTW in our database:

        for ($i = 0; $i < 5; $i++) {
            PtwMstType::create([
                "TYPE_NAME" => $vvsFaker->word,
                 "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
