<?php

namespace Database\Seeders;

use App\Models\MstSite;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstSiteSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //lets truncate the existing records
       MstSite::truncate();

       $vvsFaker = \Faker\Factory::create();
       $userIds = User::pluck('ID')->all();

       for ($i = 0; $i < 4; $i++) {
        MstSite::create([
               "SITE_NAME" => $vvsFaker->word,
               "CREATED_BY" => $userIds[array_rand($userIds)],
           ]);
       }
    }
}
