<?php

namespace Database\Seeders;

use App\Models\MstLocation;
use App\Models\MstSite;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstLocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        MstLocation::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $siteIds = MstSite::pluck('SITE_ID')->all();
       
 
        for ($i = 0; $i < 10; $i++) {
            MstLocation::create([
                "LOCATION_NAME" => $vvsFaker->word,
                "SITE_ID" => $siteIds[array_rand($siteIds)],
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
