<?php

namespace Database\Seeders;

use App\Models\PtwMstDeclaration;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstDeclarationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        PtwMstDeclaration::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
       
 
        for ($i = 0; $i < 10; $i++) {
            PtwMstDeclaration::create([
                "DECLARATION_NAME" => $vvsFaker->word,
                "DECLARATION_SECTION" => $vvsFaker->word,
                "DECLARATION_GROUP" => rand(1,2),
                "IS_MANDATORY_DURING_ADD" => 1,
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
