<?php

namespace Database\Seeders;

use App\Models\PtwMstContractor;
use App\Models\MstSite;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstContractorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
         //lets truncate the existing records
       PtwMstContractor::truncate();

       $vvsFaker = \Faker\Factory::create();
       $userIds = User::pluck('ID')->all();
       $siteIds = MstSite::pluck('SITE_ID')->all();

       for ($i = 0; $i < 20; $i++) {
        PtwMstContractor::create([
                "SITE_ID" => $siteIds[array_rand($siteIds)],
               "CONTRACTOR_NAME" => $vvsFaker->word,
               "CREATED_BY" => $userIds[array_rand($userIds)],
           ]);
       }
    }
}
