<?php

namespace Database\Seeders;

use App\Models\PtwMstChecklist;
use App\Models\PtwMstType;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstChecklistSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
         //lets truncate the existing records
       PtwMstChecklist::truncate();

       $vvsFaker = \Faker\Factory::create();
       $userIds = User::pluck('ID')->all();
       $mstTypeIds = PtwMstType::pluck('TYPE_ID')->all();
       
       

       for ($i = 0; $i < 30; $i++) {
        PtwMstChecklist::create([
               "CHECKLIST_NAME" => $vvsFaker->word,
               "TYPE_ID" => $mstTypeIds[array_rand($mstTypeIds)],
               "CREATED_BY" => $userIds[array_rand($userIds)],
           ]);
       }
    }
}
