<?php

namespace Database\Seeders;

use App\Models\PtwMstChecklistOption;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstChecklistOptionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //lets truncate the existing records
       PtwMstChecklistOption::truncate();

       $vvsFaker = \Faker\Factory::create();
       $userIds = User::pluck('ID')->all();
       

       for ($i = 0; $i < 10; $i++) {
        PtwMstChecklistOption::create([
               "CHECKLIST_OPTION_NAME" => $vvsFaker->word,
               "CREATED_BY" => $userIds[array_rand($userIds)],
           ]);
       }
    }
}
