<?php

namespace Database\Seeders;

use App\Models\Ptw;
use App\Models\PtwMapFiles;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMapFilesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        PtwMapFiles::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $ptwIds = Ptw::pluck('ID')->all();
       
 
        for ($i = 0; $i < 20; $i++) {
            PtwMapFiles::create([
                "PTW_ID" => $ptwIds[array_rand($ptwIds)],
                "FILE_CAPTION" => $vvsFaker->word,
                "FILE_NAME" => $vvsFaker->word,
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
