<?php

namespace Database\Seeders;

use App\Models\Ptw;
use App\Models\PtwMapChecklist;
use App\Models\PtwMstChecklist;
use App\Models\PtwMstChecklistOption;
use App\Models\PtwMstType;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMapChecklistSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        PtwMapChecklist::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $ptwIds = Ptw::pluck('ID')->all();
        $checklistIds = PtwMstChecklist::pluck('CHECKLIST_ID')->all();
        $checklistOptionIds = PtwMstChecklistOption::pluck('CHECKLIST_OPTION_ID')->all();
       
 
        for ($i = 0; $i < 50; $i++) {
            PtwMapChecklist::create([
                "CHECKLIST_NAME" => $vvsFaker->word,
                "OPTION_NAME" => $vvsFaker->word,
                "PTW_ID" => $ptwIds[array_rand($ptwIds)],
                "CHECKLIST_ID" => $checklistIds[array_rand($checklistIds)],
                "OPTION_ID" => $checklistOptionIds[array_rand($checklistOptionIds)],
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
