<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("USER_LOG_MODIFICATION");
        Schema::create('USER_LOG_MODIFICATION', function (Blueprint $table) {
            $table->bigIncrements("LOG_MODIFICATION_ID");
            $table->unsignedBigInteger("USER_ID")->nullable(false);
            $table->foreign('USER_ID')->references('ID')->on('USERS');
            $table->string("DEMAND_NO",100)->nullable(false);
            $table->text("OLD_VALUE")->nullable(false);
            $table->text("NEW_VALUE")->nullable(false);
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('USER_LOG_MODIFICATION');
    }
};
