<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("PTW");
        Schema::create('PTW', function (Blueprint $table) {
            $table->bigIncrements("ID");
            $table->unsignedBigInteger("SITE_ID")->nullable(false);
            $table->foreign("SITE_ID")->references("SITE_ID")->on("MST_SITE");
            $table->string("AUTO_GEN_REF_NO",50)->nullable(false);
            $table->unsignedBigInteger("TYPE_ID")->nullable(false);
            $table->foreign("TYPE_ID")->references("TYPE_ID")->on("PTW_MST_TYPE");
            $table->integer("TOP_PARENT_PTW_ID")->default(0);
            $table->integer("PARENT_PTW_ID")->default(0);
            $table->integer("RENEWAL_COUNT")->default(0);
            $table->unsignedBigInteger("LOCATION_ID")->nullable(false);
            $table->foreign("LOCATION_ID")->references("LOCATION_ID")->on("MST_LOCATION");
            $table->timestamp('PERMIT_START_TIME')->nullable(false);
            $table->timestamp('PERMIT_END_TIME')->nullable(false);
            $table->string("DESCRIPTION",600)->nullable();
            $table->integer("IS_CONTRACTOR_INFO_REQUIRED")->nullable();
            $table->unsignedBigInteger("CONTRACTOR_ID")->nullable(false);
            $table->foreign("CONTRACTOR_ID")->references("CONTRACTOR_ID")->on("PTW_MST_CONTRACTOR");
            $table->unsignedBigInteger("STAGE_ID")->nullable(false);
            $table->foreign("STAGE_ID")->references("STAGE_ID")->on("PTW_MST_STAGE");
            $table->string("REMARKS",600)->nullable();
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->string("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ptws');
    }
};
