<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("PTWTYPE_MAP_WORKERS");
        Schema::create('PTWTYPE_MAP_WORKERS', function (Blueprint $table) {
            $table->bigIncrements("MAP_WORKER_TYPE_ID");
            $table->unsignedBigInteger("WORKER_ID")->nullable(false);
            $table->foreign("WORKER_ID")->references("WORKER_ID")->on("PTW_MST_WORKERS");
            $table->unsignedBigInteger("TYPE_ID")->nullable(false);
            $table->foreign("TYPE_ID")->references("TYPE_ID")->on("PTW_MST_TYPE");
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->integer("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('PTWTYPE_MAP_WORKERS');
    }
};
