<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("PTW_MST_DECLARATION");
        Schema::create('PTW_MST_DECLARATION', function (Blueprint $table) {
            $table->bigIncrements("DECLARATION_ID");
            $table->string("DECLARATION_NAME",250)->nullable(false);
            $table->string("DECLARATION_SECTION",20)->nullable(false)->comment("e.g. ptw_initial,ptw_move_forward popup");
            $table->integer("DECLARATION_GROUP")->default(1)->comment("e.g. 1,2");
            $table->integer("IS_MANDATORY_DURING_ADD")->default(1)->comment("IF 1,During submission of PTW add form, checkboxes are mandatory else optional.");
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->integer("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('PTW_MST_DECLARATION');
    }
};
