<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("PTW_ACTION_HISTORY");
        Schema::create('PTW_ACTION_HISTORY', function (Blueprint $table) {
            $table->bigIncrements("HISTORY_ID");
            $table->unsignedBigInteger("PTW_ID")->nullable(false);
            $table->foreign("PTW_ID")->references("ID")->on("PTW");
            $table->unsignedBigInteger("ACTION_TAKER_ID")->nullable(false);
            $table->foreign("ACTION_TAKER_ID")->references("ID")->on("USERS");
            $table->unsignedBigInteger("STAGE_ID")->nullable(false);
            $table->foreign("STAGE_ID")->references("STAGE_ID")->on("PTW_MST_STAGE");
            $table->string("COMMENTS",600)->nullable();
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->integer("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('PTW_ACTION_HISTORY');
    }
};
