<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("MST_LOCATION");
        Schema::create('MST_LOCATION', function (Blueprint $table) {
            $table->bigIncrements("LOCATION_ID");
            $table->unsignedBigInteger("SITE_ID")->nullable(false);
            $table->foreign("SITE_ID")->references("SITE_ID")->on("MST_SITE");
            $table->string("LOCATION_NAME",30)->nullable(false);
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->integer("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('MST_LOCATION');
    }
};
