<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("USER_LOGIN_HISTORY");
        Schema::create('USER_LOGIN_HISTORY', function (Blueprint $table) {
            $table->bigIncrements("LOGIN_HISTORY_ID");
            $table->unsignedBigInteger("USER_ID")->nullable(false);
            $table->foreign("USER_ID")->references("ID")->on("USERS");
            $table->timestamp("LOGIN_TIME")->nullable();
            $table->timestamp("LOGOUT_TIME")->nullable();
            $table->string("IP_ADDRESS",20)->nullable(false);
            $table->text("BROWSER_AGENT")->nullable(false);
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->integer("IS_ACTIVE")->default(1);
            
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('USER_LOGIN_HISTORY');
    }
};
