<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("PTW_MAP_PRECAUTIONS");
        Schema::create('PTW_MAP_PRECAUTIONS', function (Blueprint $table) {
            $table->bigIncrements("MAP_PRECAUTION_ID");
            $table->unsignedBigInteger("PTW_ID")->nullable(false);
            $table->foreign("PTW_ID")->references("ID")->on("PTW");
            $table->string("TAG_NO",15)->nullable(false);
            $table->string("DEVICE",50)->nullable(false);
            $table->string("LOCATION",50)->nullable(false);
            $table->integer("ACTION_ID")->nullable(false)->comment('1=CLOSED,2=OFF,3=OPEN,4=ON');
            $table->integer("TAGGED_BY")->nullable(false);
            $table->timestamp('TAGGED_ON')->nullable(false);
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->string("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('PTW_MAP_PRECAUTIONS');
    }
};
