<?php

namespace App\Services\UserAcl;

use App\Http\Resources\UserAcl\UserAclMapResource;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\UserAclMap;
use App\Models\MasterMstMenu;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class UserAclMapServices extends UserAclMapResource
{
    public $vvsUserAclMapModel;
    public $page;
    public $pageSize;
    public $vvsTrModel;
    
    public function __construct()
    {
        $this->vvsUserAclMapModel = new UserAclMap();        
    }

    public function getUserMenuList($requestData)
    {
        $userId = $requestData->CREATED_BY;

        $menulistStr = UserAclMap::select(
            'USERS_ACL_MAP.MENU_ARRAY'
        )
        ->leftJoin('USERS_MAP_ROLE', function($join) use ($userId) {
            $join->on('USERS_MAP_ROLE.ROLE_ID', '=', 'USERS_ACL_MAP.ROLE_ID')
                ->where('USERS_MAP_ROLE.USER_ID', $userId)
                ->where('USERS_MAP_ROLE.IS_ACTIVE', 1)
                ->where('USERS_MAP_ROLE.IS_DELETED', 0);
        })
        ->where('USERS_ACL_MAP.IS_ACTIVE', 1)
        ->where('USERS_ACL_MAP.IS_DELETED', 0)                    
        ->whereNotNull('USERS_MAP_ROLE.ROLE_ID')
        ->get()->toArray();

        $menuStr = '';
        if(!empty($menulistStr)){
            foreach ($menulistStr as $key => $value) {
                $menuStr.= $value['MENU_ARRAY'].",";
            }
        }
        
        $menuArr = array_unique(explode(',',rtrim($menuStr, ',')));
        
        return MasterMstMenu::select(
            'M_MST_MENU.MENU_ID',
            'M_MST_MENU.MENU_GROUP_ID',
            'M_MST_MENU.MENU_NAME',
            'M_MST_MENU.MENU_GROUP_ORDER',
            'M_MST_MENU.MENU_URL',
            'M_MST_MENU.MENU_ORDER',
            'M_MST_MENU_GROUP.MENU_GROUP_NAME',
            'M_MST_MENU_GROUP.MENU_GROUP_ICON'
        )
        ->leftJoin('M_MST_MENU_GROUP', function($join) {
            $join->on('M_MST_MENU_GROUP.MENU_GROUP_ID', '=', 'M_MST_MENU.MENU_GROUP_ID')                
                ->where('M_MST_MENU_GROUP.IS_ACTIVE', 1)
                ->where('M_MST_MENU_GROUP.IS_DELETED', 0);
        })
        ->where('M_MST_MENU.IS_ACTIVE', 1)
        ->where('M_MST_MENU.IS_DELETED', 0)                    
        ->whereIn('M_MST_MENU.MENU_ID',$menuArr)
        ->orderBy('M_MST_MENU.MENU_GROUP_ORDER')
        ->orderBy('M_MST_MENU.MENU_ORDER')
        ->get();       
          
    }

       
}