<?php

namespace App\Services\TRAINING;
use App\Http\Requests\TRAINING\AddRequest;
use App\Http\Resources\TRAINING\TrainingResource;
use App\Models\MstSite;
use App\Models\Training;
use App\Models\TrainingMapParticipant;
use App\Models\TrainingMapDeclaration;
use App\Models\TrainingMstDeclaration;
use App\Models\TrainingMapFile;
use App\Models\TrainingMstTopic;
use App\Models\TrainingMstType;
use App\Models\User;
use App\Models\MstLocation;
use App\Models\UserMapRole;
use App\Models\HiraMstLocation;

use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Http\Traits\EncDecService;

class TrainingServices extends TrainingResource
{
    use EncDecService;
    public $vvsTrainingModel;
    public function __construct()
    {
        $this->vvsTrainingModel = new Training();
    }

     /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'YEAR' => 'YEAR',
            'MONTH' => 'MONTH'
        ];
    }

    public function getTrainingList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        $query = Training::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site'];
        $requestData->YEAR = $requestData->YEAR ?? date("Y");        
        $startDate = $requestData->YEAR.'-01-01';
        $enddate = $requestData->YEAR.'-12-31';
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "YEAR") {
                    $query->whereDate('TR_SCHEDULED_START_DATE', '<=',$enddate);
                    $query->whereDate('TR_SCHEDULED_END_DATE', '>=',$startDate);
                }else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->get();
    }

    public function getPlannedTrainingList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        $query = Training::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site'];
        $requestData->YEAR = $requestData->YEAR ?? date("Y");
        $startDate = $requestData->YEAR.'-01-01';
        $enddate = $requestData->YEAR.'-12-31';
        if(isset($requestData->MONTH) && !in_array($requestData->MONTH,[13])){
            $month  = $requestData->MONTH;
            $startDate = date('Y-m-01', strtotime($requestData->YEAR.'-'.$month.'-01'));
            $enddate = date('Y-m-t', strtotime($requestData->YEAR.'-'.$month.'-01'));
        }       
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($key == "YEAR" || $key == "MONTH") {
                    $query->where(function($query3) use ($startDate,$enddate) {
                        $query3->whereBetween('TR_SCHEDULED_START_DATE', [$startDate,$enddate]);
                        $query3->orWhereBetween('TR_SCHEDULED_END_DATE', [$startDate,$enddate]);
                    });
                }else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        $query->where('IS_PLANNED', 1);
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("TR_SCHEDULED_START_DATE");
        $query->orderBy("TYPE_ID");
        $query->orderBy("TOPIC_NAME");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->get();
    }

    public function getUnPlannedTrainingList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        $query = Training::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site'];
        $requestData->YEAR = $requestData->YEAR ?? date("Y");
        $startDate = $requestData->YEAR.'-01-01';
        $enddate = $requestData->YEAR.'-12-31';
        if(isset($requestData->MONTH) && !in_array($requestData->MONTH,[13])){
            $month  = $requestData->MONTH;
            $startDate = date('Y-m-01', strtotime($requestData->YEAR.'-'.$month.'-01'));
            $enddate = date('Y-m-t', strtotime($requestData->YEAR.'-'.$month.'-01'));
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($key == "YEAR" || $key == "MONTH") {
                    $query->where(function($query3) use ($startDate,$enddate) {
                        $query3->whereBetween('TR_START_DATE', [$startDate,$enddate]);
                        $query3->orWhereBetween('TR_END_DATE', [$startDate,$enddate]);
                    });
                }else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        $query->where('IS_PLANNED', 0);
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        return $query->paginate($this->pageSize, ['*'], 'page', $this->page);
    }

    public function getUnPlannedTrainingListTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        $query = Training::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site'];
        $requestData->YEAR = $requestData->YEAR ?? date("Y");
        $startDate = $requestData->YEAR.'-01-01';
        $enddate = $requestData->YEAR.'-12-31';
        if(isset($requestData->MONTH) && !in_array($requestData->MONTH,[13])){
            $month  = $requestData->MONTH;
            $startDate = date('Y-m-01', strtotime($requestData->YEAR.'-'.$month.'-01'));
            $enddate = date('Y-m-t', strtotime($requestData->YEAR.'-'.$month.'-01'));
        }        
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($key == "YEAR" || $key == "MONTH") {
                    $query->where(function($query3) use ($startDate,$enddate) {
                        $query3->whereBetween('TR_START_DATE', [$startDate,$enddate]);
                        $query3->orWhereBetween('TR_END_DATE', [$startDate,$enddate]);
                    });
                }else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        $query->where('IS_PLANNED', 0);
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->count();
    }

    public function getTrainingDetails($requestData)
    {
        return Training::where("ID", $requestData->TR_ID)->first();
    }

    protected function autoGenNumberGeneration($requestedData)
    {
        //$siteId = $requestedData -> SITE_ID;
        if($requestedData->ID > 0){
            $siteId = Training::where("ID",$requestedData->ID)->pluck("LOCATION_ID")->first();
        }else{
            $siteId = $requestedData -> LOCATION_ID;
        }
        //$siteName   = MstSite::where("SITE_ID", $siteId)->pluck("SITE_ALIAS")->first();
        $siteName   = HiraMstLocation::where("LOCATION_ID", $siteId)->pluck("LOCATION_ALIAS")->first();          
        //$initialSearch = "SHW_IND_"; 
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            $initialSearch = "DRAFT_";
        }
        else{
            $initialSearch = "SHW_IND_";
        }
        $previousNumber = DB::table('TRAINING')
                            ->where("LOCATION_ID", $siteId)
                            ->where("TR_REFERENCE_NO", "LIKE", $initialSearch . strtoupper($siteName) . "%")
                            ->max(DB::raw("CAST(regexp_replace(\"TR_REFERENCE_NO\", '\\D', '', 'g') AS INTEGER)"));        
        $previousNumber = $previousNumber ?: 0;

        // Define prefix and suffix
        $prefix = config("constants.TR_REFERENCE_PREFIX");
        $prefixMod = config("constants.TR_PREFIX");
        $siteMappingArray = typeIdTextMapping();
        //$middle = "_".$siteMappingArray[$requestedData -> SITE_ID]."_";  
        $middle = "_".$prefixMod;       
        
        // Increment the last digit based on the value of $previousNumber
        $lastDigit = $previousNumber + 1;

        // Concatenate all parts to form the output
        //return $prefix . strtoupper($siteName) . $middle . $lastDigit;
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            return $initialSearch.strtoupper($siteName)."-".$lastDigit;
        }else{
            return $prefix . strtoupper($siteName) . $middle . $lastDigit;
        }
    }

    protected function getStages($requestAction)
    {
        $stageId = 1;
        if (strtoupper($requestAction) == "DRAFT") {
            $stageId = 1;
        } elseif (strtoupper($requestAction) == "SAVE") {
            $stageId = 2;
        } elseif (strtoupper($requestAction) == "MOVE_FORWARD") {
            $stageId = 3;
        } elseif (strtoupper($requestAction) == "SEND_BACK") {
            $stageId = 4;
        } elseif (strtoupper($requestAction) == "APPROVE") {
            $stageId = 5;
        } elseif (strtoupper($requestAction) == "REJECT") {
            $stageId = 6;
        } elseif (strtoupper($requestAction) == "RENEW") {
            $stageId = 7;
        }
        return $stageId;
    }    
    
    protected function transformTrainingTableData($requestData)
    {
        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY) ->where("MODULE_NAME", "Training")->pluck("ROLE_ID")->first();
        if (in_array(strtoupper($requestData->ACTION), ["DRAFT", "SAVE","RENEW"])) {

            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];
                        
            if (isset($requestData->SITE_ID)) {
                $processedData["SITE_ID"]  =  $requestData->SITE_ID;
            }
            if (isset($requestData->LOCATION_ID)) {
                $processedData["LOCATION_ID"]  =  $requestData->LOCATION_ID;
            }
            if (isset($requestData->TYPE_ID)) {
                $processedData["TYPE_ID"]  =  $requestData->TYPE_ID;
            }
            if (isset($requestData->TOPIC_NAME)) {
                //$processedData["TOPIC_ID"]  =  $requestData->TOPIC_ID;
                $prevTopic = TrainingMstTopic::where('IS_DELETED',0)->where("TR_TOPIC_NAME","ILIKE",'%'.strtoupper($requestData->TOPIC_NAME).'%')
                            ->where("TR_TYPE_ID",$requestData->TYPE_ID);                
                if($prevTopic -> count()){
                    $preTopicData = $prevTopic->first();
                    $processedData["TOPIC_ID"]  =  $preTopicData->TR_TOPIC_ID;
                    $processedData["TOPIC_NAME"]  =  strtoupper($preTopicData->TR_TOPIC_NAME);
                }else{                    
                    $processedDataTp["TR_TOPIC_NAME"] =  strtoupper($requestData->TOPIC_NAME);
                    $processedDataTp["TR_TYPE_ID"] =  (int)$requestData->TYPE_ID;
                    $processedDataTp["CREATED_BY"] = $requestData->CREATED_BY;
                    $processedDataTp["CREATED_ON"] = currentDateTime();
                    $topicInsert = TrainingMstTopic::create($processedDataTp);
                    $topicId = $topicInsert->TR_TOPIC_ID;
                    $processedData["TOPIC_ID"]  =  $topicId;
                    $processedData["TOPIC_NAME"]  =  strtoupper($requestData->TOPIC_NAME);
                }
            }
            /*if (isset($requestData->TR_SCHEDULED_START_DATE)) {
                $processedData["TR_SCHEDULED_START_DATE"]  =
                createSlashDate($requestData->TR_SCHEDULED_START_DATE, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->TR_SCHEDULED_END_DATE)) {
                $processedData["TR_SCHEDULED_END_DATE"]  =
                createSlashDate($requestData->TR_SCHEDULED_END_DATE, config("constants.DATE_TIME_FORMAT"));
            }*/
            if (isset($requestData->TR_START_DATE)) {
                $processedData["TR_START_DATE"]  =
                createSlashDate($requestData->TR_START_DATE, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->TR_END_DATE)) {
                $processedData["TR_END_DATE"]  =
                createSlashDate($requestData->TR_END_DATE, config("constants.DATE_TIME_FORMAT"));
            }            
            if (isset($requestData->TRAINERS)) {
                $processedData["TRAINERS"]  =  $requestData->TRAINERS;
            }
            if (isset($requestData->REMARKS)) {
                $processedData["REMARKS"]  =  $requestData->REMARKS;
            }
            
            if( strtoupper($requestData->ACTION) == "DRAFT"){
                if ($requestData->ID == 0 ) {               
                    $processedData["TR_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                }
            }
            if( strtoupper($requestData->ACTION) == "SAVE"){
                if ($requestData->ID == 0 ) {               
                    $processedData["TR_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                }
                if ($requestData->ID > 0 ) { 
                    $inspDraftAlready = Training::where("ID",$requestData->ID)->where("TR_REFERENCE_NO","LIKE","DRAFT_%");              
                    if($inspDraftAlready -> exists()){
                        $processedData["TR_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                    }                                        
                }               
            } 
        } else {
            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];
        }

        if (isset($requestData->ID) &&  $requestData->ID > 0) {
            $processedData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedData["MODIFIED_ON"] = currentDateTime();
        } else {
            $processedData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedData["CREATED_ON"] = currentDateTime();
        }
        return $processedData;
    }

    public function save($requestData)
    {  
        DB::beginTransaction();
        try { 
        
            $trId = $requestData->ID;
            if($requestData->ACTION != "DELETE"){
                $processedData = $this->transformTrainingTableData($requestData);
            }else{
                $processedData["IS_ACTIVE"] = 0;
                $processedData["IS_DELETED"] = 1;
                $processedData["MODIFIED_BY"] = $requestData->CREATED_BY;
                $processedData["MODIFIED_ON"] = currentDateTime();
            }
            if ($trId > 0) {
                //update ptw tables and upsert all associated tables
                Training::where("ID", $trId)->update($processedData);
            } else {
                //insert Training tables and insert all associated tables
                //insert into Training table
                $trInsert = Training::create($processedData);
                $trId = $trInsert->ID;
            }

            $trMapParticipantData = $this->transformParticipantData($requestData, $trId); 

            $trMapDeclarationData = $this->transformTrainingMapDeclarationTableData($requestData, $trId);
            if (count($trMapDeclarationData)) {
                //soft delete old data if exists
                $addRequestClass = new AddRequest();
                $declarationSectionId = $addRequestClass->getDeclarationSectionbyAction($requestData->ACTION);

                if ($declarationSectionId == 1) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_ADD")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 2) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_MOVE_FORWARD")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 3) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_APPROVE")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 4) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_REJECT")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 5) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_REQUEST_FOR_CLOSURE")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 6) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_CLOSE")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 7) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_SUSPEND")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 8) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_REQUEST_FOR_SUSPEND")->pluck("DECLARATION_ID")->all();
                }elseif ($declarationSectionId == 9) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_RENEW")->pluck("DECLARATION_ID")->all();
                }elseif ($declarationSectionId == 10) {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "TR_ACCEPT_CONTROL_MEASURES")->pluck("DECLARATION_ID")->all();
                } else {
                    $allDeclarationData = TrainingMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->whereNot("DECLARATION_GROUP", "TR_ADD")->pluck("DECLARATION_ID")->all();
                }
                TrainingMapDeclaration::where("TR_ID", $trId)->where("IS_DELETED", 0)
                    ->whereIn("DECLARATION_ID", $allDeclarationData)
                    ->update([
                        "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                        "MODIFIED_ON" => currentDateTime()
                    ]);
                //insert new data
                TrainingMapDeclaration::insert($trMapDeclarationData);
            }

            //insert into Inspection_MAP_FILES
            $this->trainingFileUpload($requestData, $trId);
            DB::commit();   
        if($trId != ""){
            return Training::where("ID", $trId)->pluck("TR_REFERENCE_NO")->first();
        }else{
            return "";
        }
        } catch (\Exception $e) {
            //     // If an exception occurs during the transaction, rollback the changes
                DB::rollBack();
                prd($e->getMessage());
            //     // You can handle the exception here, log it, or return an error response
                return "";
        }
    }

    

    protected function transformParticipantData($requestData, $trId)
    {
        TrainingMapParticipant::where("TR_ID", $trId)->where("IS_DELETED", 0)
        ->update([
           "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
            "MODIFIED_ON" => currentDateTime()
        ]);
        if (isset($requestData->PARTICIPANT)) {
            if (count($requestData->PARTICIPANT) > 0) {                
                $processedData = [];
                foreach ($requestData->PARTICIPANT as $value) {
                    $processedData[] = [
                        "TR_ID" => $trId,
                        "NAME" => $value->NAME,
                        "DESIGNATION" => $value->DESIGNATION,
                        "ORGANIZATION" => $value->ORGANIZATION,
                        "SCORE" => $value->SCORE,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
                TrainingMapParticipant::insert($processedData);
            }
        }
        return $trId;
    }

    protected function transformTrainingMapDeclarationTableData($requestData, $trId)
    {
        $processedData = [];
        if (isset($requestData->DECLARATION_ID)) {
            if (count($requestData->DECLARATION_ID) > 0) {
                foreach ($requestData->DECLARATION_ID as $value) {
                    $processedData[] = [
                        "TR_ID" => $trId,
                        "DECLARATION_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    

    public function trainingFileUpload($request, $trId)
    {

        if ($trId) {
            $uploadPath = './' . config('constants.TR_FILE_UPLOAD_PATH');
            $absoluteBasePath = public_path(config('constants.TR_FILE_UPLOAD_PATH'));
            if (!file_exists($uploadPath)) {
                mkdir($uploadPath, 0755, true);
            }
            $fileList = (isset($request->FILES)) ? $request->FILES : [];
            if (count($fileList)) {
                foreach ($fileList as $fileData) {
                    if ($fileData->FILE_ID == 0) {
                        $file = new TrainingMapFile([
                            'TR_ID' => $trId,
                            'FILE_NAME' => basename($fileData->FILE),
                            'FILE_CAPTION' => $fileData->FILE_CAPTION,
                            'FILE_PATH' => $fileData->FILE,
                            'CREATED_BY' => $request->CREATED_BY,
                            "CREATED_ON" => currentDateTime()
                        ]);
                        $file->save();
                    } else {
                        //request for deletion of the file
                        $fileDetails = TrainingMapFile::where('MAP_FILE_ID', $fileData->FILE_ID)->first();
                        if ($fileDetails) {
                            $fileDeleted = TrainingMapFile::where('MAP_FILE_ID', $fileData->FILE_ID)->delete();
                            if ($fileDeleted) {
                                @unlink($absoluteBasePath . $fileDetails->FILE_NAME);
                            }
                        }
                    }
                }
            }
        }
    }

    // calender entry
    public function saveTrainingCal($requestData)
    {
        DB::beginTransaction();
        try { 
        $requestData->ACTION="DRAFT";
        $requestData->ID=0;
        $retId = 0;
        $year = $requestData->YEAR??date("Y");
        $monthArr = ["JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC"];
        $monthNum = getTrainingMonthNumber($year);
        $user = User::find($requestData->CREATED_BY);
        $userFullName = $this->customDecrypt($user->FIRST_NAME)." ".$this->customDecrypt($user->LAST_NAME);
        if (isset($requestData->TRAINING_DTLS)) {
            if (count($requestData->TRAINING_DTLS) > 0) {
                foreach ($requestData->TRAINING_DTLS as $value) {
                    $processedData["SITE_ID"]  =  $requestData->SITE_ID;
                    $processedData["LOCATION_ID"]  =   $requestData->LOCATION_ID;
                    $processedData["TRAINERS"]  =  $userFullName;
                    $processedData["IS_PLANNED"]  =  1;
                    if($value->TYPE){
                        $prevType = TrainingMstType::where('IS_DELETED',0)->where("TR_TYPE_NAME","ILIKE",'%'.strtoupper($value->TYPE).'%')
                                    ->where('CATEGORY',2);           
                        if($prevType -> count()){
                            $preTypeData = $prevType->first();
                            $processedData["TYPE_ID"]  =  $preTypeData->TR_TYPE_ID; 
                            $value->TYPE_ID=$preTypeData->TR_TYPE_ID;                           
                        }else{                    
                            $processedDataTp2["TR_TYPE_NAME"] =  strtoupper($value->TYPE); 
                            $processedDataTp2["CATEGORY"]  =  2;                           
                            $processedDataTp2["CREATED_BY"] = $requestData->CREATED_BY;
                            $processedDataTp2["CREATED_ON"] = currentDateTime();
                            $typeInsert = TrainingMstType::create($processedDataTp2);
                            $typeId = $typeInsert->TR_TYPE_ID;
                            $processedData["TYPE_ID"]  =  $typeId;
                            $value->TYPE_ID=$typeInsert->TR_TYPE_ID;
                        }
                    }
                    if($value->TOPIC){
                        $prevTopic = TrainingMstTopic::where('IS_DELETED',0)->where("TR_TOPIC_NAME","ILIKE",'%'.strtoupper($value->TOPIC).'%')
                                    ->where("TR_TYPE_ID",$value->TYPE_ID);                
                        if($prevTopic -> count()){
                            $preTopicData = $prevTopic->first();
                            $processedData["TOPIC_ID"]  =  $preTopicData->TR_TOPIC_ID;
                            $processedData["TOPIC_NAME"]  =  strtoupper($preTopicData->TR_TOPIC_NAME);
                            $topicId = $preTopicData->TR_TOPIC_ID;
                        }else{                    
                            $processedDataTp["TR_TOPIC_NAME"] =  strtoupper($value->TOPIC);
                            $processedDataTp["TR_TYPE_ID"] =  (int)$value->TYPE_ID;
                            $processedDataTp["CREATED_BY"] = $requestData->CREATED_BY;
                            $processedDataTp["CREATED_ON"] = currentDateTime();
                            $topicInsert = TrainingMstTopic::create($processedDataTp);
                            $topicId = $topicInsert->TR_TOPIC_ID;
                            $processedData["TOPIC_ID"]  =  $topicId;
                            $processedData["TOPIC_NAME"]  =  strtoupper($value->TOPIC);
                        }
                    }
                    foreach ($monthArr as $key1 => $value1) {
                        if(isset($value->$value1) && trim($value->$value1)!="" && strtoupper($value->$value1) == "YES"){
                            $trMonth = $monthNum[$value1];
                            
                            $startDate =  date("Y-m-01 H:i:s",strtotime($trMonth["START_DATE"]));
                            $endDate = date("Y-m-t H:i:s",strtotime($trMonth["START_DATE"]));
                            $startDate1 =  date("Y-m-01",strtotime($trMonth["START_DATE"]));
                            $endDate1 = date("Y-m-t",strtotime($trMonth["START_DATE"]));

                            Training::where("SITE_ID", $processedData["SITE_ID"])
                            ->where("LOCATION_ID", $processedData["LOCATION_ID"])                            
                            ->where("TYPE_ID", $processedData["TYPE_ID"])
                            ->where("TOPIC_ID", $processedData["TOPIC_ID"])
                            ->where("TRAINERS", $processedData["TRAINERS"])
                            ->whereBetween('TR_SCHEDULED_START_DATE', [$startDate1,$endDate1])
                            ->where("STAGE_ID",1)->where("IS_DELETED",0)->where("IS_PLANNED",1)
                            ->update([
                                "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                                "MODIFIED_ON" => currentDateTime()
                            ]);

                            $processedData["TR_REFERENCE_NO"]  = $this->autoGenNumberGeneration($requestData);
                            $processedData["TR_SCHEDULED_START_DATE"]  =  createSlashDate($startDate, config("constants.DATE_TIME_FORMAT"));
                            $processedData["TR_SCHEDULED_END_DATE"]  =  createSlashDate($endDate, config("constants.DATE_TIME_FORMAT"));
                            $processedData["STAGE_ID"]  =  1;
                            $processedData["CREATED_BY"] = $requestData->CREATED_BY;
                            $processedData["CREATED_ON"] = currentDateTime();
                            $trInsert = Training::create($processedData);
                            $retId = $trInsert->ID;
                        }
                    }
                    
                }
            }
        }
        DB::commit();
        if($retId != 0){
            return Training::where("ID", $retId)->pluck("TR_REFERENCE_NO")->first();
        }else{
            return "";
        }
         } catch (\Exception $e) {
            //     // If an exception occurs during the transaction, rollback the changes
                DB::rollBack();
                prd($e->getMessage());
            //     // You can handle the exception here, log it, or return an error response
                return "";
        }            
    }

    public function getTrainingDetailsExport($requestData)
    {
        $query = Training::query();

        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location','stage', 'topic',
                                'files', 'participants', 'declaredby'];
    
        // Add where clause for the inspection ID
        $query->where("ID", $requestData->TR_ID);
    
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        $query->with(['declaredby.createdby']);
        // $query->with(['actionReportedHistory.actionTracker']);
        // $query->with(['mapRecipent.recipent']);
    
        // Fetch the inspection details
        return $query->first();
    }
    
}