<?php

namespace App\Services\TRAINING;

use App\Http\Resources\TRAINING\TrainingMstDeclarationResource;
use App\Models\TrainingMapDeclaration;
use App\Models\TrainingMstDeclaration;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;

class TrainingMstDeclarationServices extends TrainingMstDeclarationResource
{
    public $vvsTrainingDeclModel;
    public function __construct(){
        $this->vvsTrainingDeclModel = new TrainingMstDeclaration();
    }
    

    public function getTrainingInitialDeclListOne(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%TR_ADD_ONE%')->get();
    }

    public function getTrainingInitialDeclListTwo(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%TR_ADD_TWO%')->get();
    }

    public function getTrainingMoveFrwdDeclList(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%MOVE_FORWARD%')->get();
    }

    public function getTrainingApproveDeclList(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%ACCEPT_TIMELINE%')->get();
    }

    public function getTrainingRejectDeclList(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%REJECT%')->get();
    }

    public function getTrainingCloseReqDeclList(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%REQUEST_FOR_CLOSURE%')->get();
    }

    public function getTrainingCloseDeclList(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%CLOSE%')->get();
    }

    public function getTrainingSuspendReqDeclList(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%REQUEST_FOR_SUSPEND%')->get();
    }

    public function getTrainingSuspendDeclList(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', 'SUSPEND%')->get();
    }

    public function getTrainingRenewDeclList(){
        return TrainingMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', 'RENEWED%')->get();
    }

    public function getMapDeclarationOne($tr_id,$afterSubmit){
        if( $afterSubmit == 1 ){

            return TrainingMstDeclaration::select(
                        'TR_MST_DECLARATION.DECLARATION_ID',
                        'TR_MST_DECLARATION.DECLARATION_NAME',
                        'TR_MST_DECLARATION.DECLARATION_GROUP',
                        'TR_MST_DECLARATION.DECLARATION_SECTION',
                        'TR_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                        'TR_MAP_DECLARATION.MAP_DECLARATION_ID',
                        'TR_MAP_DECLARATION.IS_ACTIVE',
                        'TR_MAP_DECLARATION.IS_DELETED'
                    )
                    ->leftJoin('TR_MAP_DECLARATION', function($join) use ($tr_id) {
                        $join->on('TR_MAP_DECLARATION.DECLARATION_ID', '=', 'TR_MST_DECLARATION.DECLARATION_ID')
                            ->where('TR_MAP_DECLARATION.TR_ID', $tr_id)
                            ->where('TR_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('TR_MAP_DECLARATION.IS_DELETED', 0);
                    })
                    ->where('TR_MST_DECLARATION.IS_ACTIVE', 1)
                    ->where('TR_MST_DECLARATION.IS_DELETED', 0)                    
                    ->where('TR_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', 'TR_ADD_ONE%')
                    ->get();
        }else{
            return TrainingMapDeclaration::select('TR_MST_DECLARATION.DECLARATION_ID', 'TR_MST_DECLARATION.DECLARATION_NAME', 'TR_MST_DECLARATION.DECLARATION_GROUP', 'TR_MST_DECLARATION.DECLARATION_SECTION','TR_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                                            'TR_MAP_DECLARATION.MAP_DECLARATION_ID',
                                            'TR_MAP_DECLARATION.IS_ACTIVE',
                                            'TR_MAP_DECLARATION.IS_DELETED'
                                            )
                            ->leftJoin('TR_MST_DECLARATION', 'TR_MAP_DECLARATION.DECLARATION_ID', '=', 'TR_MST_DECLARATION.DECLARATION_ID')
                            ->where('TR_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('TR_MAP_DECLARATION.IS_DELETED', 0)
                            ->where("TR_MAP_DECLARATION.TR_ID",$tr_id)
                            ->where('TR_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', '%TR_ADD_ONE%')
                            ->get();
                  
        }
        
    }

    public function getMapDeclarationTwo($tr_id,$afterSubmit){
        if( $afterSubmit == 1 ){

               return TrainingMstDeclaration::select(
                    'TR_MST_DECLARATION.DECLARATION_ID', 
                    'TR_MST_DECLARATION.DECLARATION_NAME', 
                    'TR_MST_DECLARATION.DECLARATION_GROUP', 
                    'TR_MST_DECLARATION.DECLARATION_SECTION',
                    'TR_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                    'TR_MAP_DECLARATION.MAP_DECLARATION_ID',
                    'TR_MAP_DECLARATION.IS_ACTIVE',
                    'TR_MAP_DECLARATION.IS_DELETED'
                )
                ->leftJoin('TR_MAP_DECLARATION', function($join) use ($tr_id) {
                    $join->on('TR_MAP_DECLARATION.DECLARATION_ID', '=', 'TR_MST_DECLARATION.DECLARATION_ID')
                         ->where('TR_MAP_DECLARATION.TR_ID', $tr_id)
                         ->where('TR_MAP_DECLARATION.IS_ACTIVE', 1)
                         ->where('TR_MAP_DECLARATION.IS_DELETED', 0);
                })
                ->where('TR_MST_DECLARATION.IS_ACTIVE', 1)
                ->where('TR_MST_DECLARATION.IS_DELETED', 0)
                ->where('TR_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', 'TR_ADD_TWO%')
                ->get();
        }else{
            return TrainingMapDeclaration::select('TR_MST_DECLARATION.DECLARATION_ID', 'TR_MST_DECLARATION.DECLARATION_NAME', 'TR_MST_DECLARATION.DECLARATION_GROUP', 'TR_MST_DECLARATION.DECLARATION_SECTION','TR_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                                            'TR_MAP_DECLARATION.MAP_DECLARATION_ID',
                                            'TR_MAP_DECLARATION.IS_ACTIVE',
                                            'TR_MAP_DECLARATION.IS_DELETED'
                                            )
                            ->Join('TR_MST_DECLARATION', 'TR_MAP_DECLARATION.DECLARATION_ID', '=', 'TR_MST_DECLARATION.DECLARATION_ID')
                            ->where('TR_MST_DECLARATION.IS_ACTIVE', 1)
                            ->where('TR_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('TR_MAP_DECLARATION.IS_DELETED', 0)
                            ->where('TR_MST_DECLARATION.IS_DELETED', 0)
                            ->where("TR_MAP_DECLARATION.TR_ID",$tr_id)
                            ->where('TR_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', '%TR_ADD_TWO%')
                            ->get();
                  
        }
        
        
        
    }

    public function getMapDeclarationAll($tr_id){
        return TrainingMapDeclaration::select(            
            'TR_MST_DECLARATION.DECLARATION_NAME', 
            'TR_MST_DECLARATION.DECLARATION_GROUP', 
            'TR_MST_DECLARATION.DECLARATION_SECTION'            
        )
        ->Join('TR_MST_DECLARATION', 'TR_MAP_DECLARATION.DECLARATION_ID', '=', 'TR_MST_DECLARATION.DECLARATION_ID')
        ->where('TR_MST_DECLARATION.IS_ACTIVE', 1)
        ->where('TR_MAP_DECLARATION.IS_ACTIVE', 1)
        ->where('TR_MAP_DECLARATION.IS_DELETED', 0)
        ->where('TR_MST_DECLARATION.IS_DELETED', 0)
        ->where("TR_MAP_DECLARATION.TR_ID",$tr_id)        
        ->get();
    }
    
}
