<?php

namespace App\Services\Report;
use App\Http\Resources\Report\ReportTrainingResource;
use App\Models\MstSite;
use App\Models\Training;
use App\Models\TrainingMapParticipant;
use App\Models\TrainingMapDeclaration;
use App\Models\TrainingMstDeclaration;
use App\Models\TrainingMapFile;
use App\Models\TrainingMstTopic;
use App\Models\TrainingMstType;
use App\Models\User;
use App\Models\MstLocation;
use App\Models\UserMapRole;
use App\Models\HiraMstLocation;

use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ReportTrainingServices extends ReportTrainingResource
{
    public $vvsTrainingModel;
    public function __construct()
    {
        $this->vvsTrainingModel = new Training();
    }

     /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'TYPE_ID' => 'TYPE_ID',
            'START_DATE' => 'START_DATE',
            'END_DATE' => 'END_DATE',

        ];
    }

    public function getTrainingList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        $query = Training::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site'];
        // $requestData->YEAR = $requestData->YEAR ?? date("Y");
        // $startDate = $requestData->START_DATE;
        // $enddate = $requestData->END_DATE;

        if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
            $startDate = $requestData->START_DATE;
            $endDate = $requestData->END_DATE;
    
            // Add special handling for date range queries
            $query->where(function($query) use ($startDate, $endDate) {
                $query->whereBetween('TR_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TR_END_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TR_SCHEDULED_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TR_SCHEDULED_END_DATE', [$startDate, $endDate]);
            });
        }
        
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($key != "START_DATE" && $key != "END_DATE") {
                //     $query->where(function($query3) use ($startDate,$enddate) {
                //         $query3->whereBetween('TR_START_DATE', [$startDate,$enddate]);
                //         $query3->orWhereBetween('TR_END_DATE', [$startDate,$enddate]);
                //     });
                //     $query->where(function($query3) use ($startDate, $endDate) {
                //         $query3->where(function($query2) use ($startDate, $endDate) {
                //             $query2->whereBetween('TR_START_DATE', [$startDate, $endDate])
                //                   ->orWhereBetween('TR_END_DATE', [$startDate, $endDate]);
                //         })
                //         ->orWhere(function($query2) use ($startDate, $endDate) {
                //             $query2->whereBetween('TR_SCHEDULED_START_DATE', [$startDate, $endDate])
                //                   ->orWhereBetween('TR_SCHEDULED_END_DATE', [$startDate, $endDate]);
                //         });
                //     });
                // }else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        // $query->where('IS_PLANNED', 0);
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);

        $totalCount = $query->count('ID');
        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        $paginatedTrainingData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedTrainingData,
            'total' => $totalCount // Total count of distinct worker IDs
        ];
    }
}