<?php

namespace App\Services\Report;

// use App\Http\Requests\PTW\AddRequest;
use App\Http\Resources\Report\ReportPtwResource;
use App\Models\MstSite;
use App\Models\Ptw;
use App\Models\PtwActionHistory;
use App\Models\PtwMapCaptcha;
use App\Models\PtwMapChecklist;
use App\Models\PtwMapDeclaration;
use App\Models\PtwMapFiles;
use App\Models\PtwMapHira;
use App\Models\PtwMapPrecautions;
use App\Models\PtwMapSopPolicies;
use App\Models\PtwMapSopPolicy;
use App\Models\PtwMapWorkers;
use App\Models\PtwMstChecklist;
use App\Models\PtwMstChecklistOption;
use App\Models\PtwMstDeclaration;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\PtwMstType;
use App\Models\MstLocation;
use App\Models\PtwMstContractor;
use App\Models\PtwMstSoapPolicies;
use App\Models\Hira;
use App\Models\PtwMstWorker;
use App\Models\PtwAuditLog;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ReportPtwServices extends ReportPtwResource
{
    public $vvsPtwModel;
    public $page;
    public $pageSize;
    public function __construct()
    {
        $this->vvsPtwModel = new Ptw();
    }
    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'TYPE_ID' => 'TYPE_ID',
            'SITE_ID' => 'SITE_ID',
            'AUTO_GEN_REF_NO' => 'AUTO_GEN_REF_NO',
            'LOCATION_ID' => 'LOCATION_ID',
            'PERMIT_START_TIME'=>'PERMIT_START_TIME',
            'PERMIT_END_TIME'=>'PERMIT_END_TIME',
            'STAGE_ID'=>'STAGE_ID'
        ];
    }

    // protected function mapRoleStageTab($requestData,$roleId){
    //     $tab = $requestData->TAB;
    //     $stageId = (!empty( $requestData ->STAGE_ID)) ? $requestData ->STAGE_ID : "";
    //     if( $stageId == "" &&  $tab == "DRAFT") $tab = "DRAFT";
    //     else if($stageId){

    //         if( $stageId == 1 ){
    //             if($roleId == 1) $tab = "DRAFT";
    //         }
    //         else if( $stageId == 3 ){
    //             if($roleId == 1) $tab = "REVIEWED";
    //             else if($roleId == 2) $tab = "REVIEWED";
    //             else if($roleId == 3) $tab = "PENDING";
    //         }
    //         else if( $stageId == 5 || $stageId == 6 || $stageId == 4 ){
    //             if($roleId == 1) $tab = "PENDING";
    //             else if($roleId == 2) $tab = "REVIEWED";
    //             else if($roleId == 3) $tab = "REVIEWED";
    //         }
    //         else if( $stageId == 7 || $stageId == 10 || $stageId == 2 ){
    //             if($roleId == 1) $tab = "REVIEWED";
    //             else if($roleId == 2) $tab = "PENDING";
    //             else if($roleId == 3) $tab = "REVIEWED";
    //         }
    //         else if( $stageId == 8 || $stageId == 11 || $stageId == 9 || $stageId == 12 || $stageId == 13){
    //             if($roleId == 1) $tab = "REVIEWED";
    //             else if($roleId == 2) $tab = "REVIEWED";
    //             else if($roleId == 3) $tab = "REVIEWED";
    //         }
    //     }
        
    //     return $tab;
    // }

    // public function calculatedTab($requestData){
    //     $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "PTW")->pluck("ROLE_ID")->first();
    //     return $this -> mapRoleStageTab($requestData,$userRoles);
    // }
    public function getPtwList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        // $tab = $requestData->TAB ?? "PENDING";

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "PTW")->pluck("ROLE_ID")->first();


        // if(!empty($requestData->STAGE_ID)){
        //     $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        // }

        $query = Ptw::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location', 'sopPolicy', 'contractor', 'stage'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "AUTO_GEN_REF_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        // if (strtoupper($tab) == "PENDING") {
        //     if ($userRoles == 1) {
        //         $query->whereIn('STAGE_ID', [4,5]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 2) {
        //         $query->whereIn('STAGE_ID', [2, 7, 10]);
        //     } elseif ($userRoles == 3) {
        //         $query->whereIn('STAGE_ID', [3]);
        //     }
        // } elseif (strtoupper($tab) == "REVIEWED") {
        //     if ($userRoles == 1) {
        //         $query->whereIn('STAGE_ID', [2, 3,7, 8,9,10,11,12,13]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 2) {
        //         $query->whereIn('STAGE_ID', [3, 4,5,6, 8,9,11,12,13]);
        //     } elseif ($userRoles == 3) {
        //         $query->whereIn('STAGE_ID', [2,4,5,6,7,8,9,10,11,12,13]);
        //     }
        // }elseif(strtoupper($tab) == "DRAFT"){
        //     if ($userRoles == 1) {
        //         $query->whereIn('STAGE_ID', [1]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     }
        // }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);


        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        return $query->paginate($this->pageSize, ['*'], 'page', $this->page);
    }
    public function getPtwListTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        // $tab = $requestData->TAB ?? "PENDING";
        $query = Ptw::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location', 'sopPolicy', 'contractor', 'stage'];

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "PTW")->pluck("ROLE_ID")->first();

        // if(!empty($requestData->STAGE_ID)){
        //     $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        // }


        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "AUTO_GEN_REF_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        // if (strtoupper($tab) == "PENDING") {
        //     if ($userRoles == 1) {
        //         $query->whereIn('STAGE_ID', [4,5]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 2) {
        //         $query->whereIn('STAGE_ID', [2, 7, 10]);
        //     } elseif ($userRoles == 3) {
        //         $query->whereIn('STAGE_ID', [3]);
        //     }
        // } elseif (strtoupper($tab) == "REVIEWED") {
        //     if ($userRoles == 1) {
        //         $query->whereIn('STAGE_ID', [2, 3,7, 8,9,10,11,12,13]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 2) {
        //         $query->whereIn('STAGE_ID', [3, 4,5,6, 8,9,11,12,13]);
        //     } elseif ($userRoles == 3) {
        //         $query->whereIn('STAGE_ID', [2,4,5,6,7,8,9,10,11,12,13]);
        //     }
        // }elseif(strtoupper($tab) == "DRAFT"){
        //     if ($userRoles == 1) {
        //         $query->whereIn('STAGE_ID', [1]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     }
        // }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->count();
    }
}