<?php

namespace App\Services\Report;
use App\Http\Resources\Report\ReportObservationResource;
use App\Models\MstSite;
use App\Models\Observation;
use App\Models\ObservationActionHistory;
use App\Models\ObservationMapDeclaration;
use App\Models\ObservationMapFile;
use App\Models\ObservationMstDeclaration;
use App\Models\ObservationMstStage;
use App\Models\ObservationMstType;
use App\Models\HiraMstLocation;
use App\Models\ObservationActionTakenDetailsLog;

use App\Models\User;
use App\Models\UserMapRole;

use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ReportObservationServices extends ReportObservationResource
{
    public $vvsObservationModel;
    public function __construct()
    {
        $this->vvsObservationModel = new Observation();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'OBSERVATION_REFERENCE_NO' => 'ID',
            'LOCATION_ID' => 'LOCATION_ID',
            'TYPE_ID' => 'OBS_TYPE_ID',
            'OBS_START_DATE'=>'OBS_START_DATE',
            'OBS_END_DATE'=>'OBS_END_DATE',
            'STAGE_ID'=>'STAGE_ID'
        ];
    }

    //code
    // protected function mapRoleStageTab($requestData,$roleId){
    //     $tab = $requestData->TAB;
    //     $stageId = (!empty( $requestData ->STAGE_ID)) ? $requestData ->STAGE_ID : "";
    //     if( $stageId == "" &&  $tab == "DRAFT") $tab = "DRAFT";
    //     else if($stageId){

    //         if( $stageId == 1 ){
    //             if($roleId == 11) $tab = "DRAFT";
    //         }
    //         else if( $stageId == 3 ){
    //             if($roleId == 11) $tab = "REVIEWED";
    //             else if($roleId == 12) $tab = "REVIEWED";                
    //         }
    //         else if( $stageId == 2 ){
    //             if($roleId == 11) $tab = "REVIEWED";
    //             else if($roleId == 12) $tab = "PENDING";                
    //         }
    //         else if( $stageId == 4){
    //             if($roleId == 11) $tab = "REVIEW";
    //             else if($roleId == 12) $tab = "PENDING";               
    //         }
    //         else if( $stageId == 5 ||  $stageId == 6){
    //             if($roleId == 11) $tab = "REVIEWED";
    //             else if($roleId == 12) $tab = "PENDING";                
    //         }            
    //         else if( $stageId == 7){
    //             if($roleId == 11) $tab = "PENDING";
    //             else if($roleId == 12) $tab = "REVIEWED";                
    //         }
    //         else if( $stageId == 8){
    //             if($roleId == 11) $tab = "REVIEWED";
    //             else if($roleId == 12) $tab = "REVIEWED";                
    //         }            
    //     }
        
    //     return $tab;
    // }

    // public function calculatedTab($requestData){
    //     $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
    //                 ->where("MODULE_NAME", "OBS")->pluck("ROLE_ID")->first();
    //     return $this -> mapRoleStageTab($requestData,$userRoles);
    // }
    
    public function getObservationList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        // $tab = $requestData->TAB ?? "PENDING";

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "OBS")->pluck("ROLE_ID")->first();


        // if(!empty($requestData->STAGE_ID)){
        //     $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        // }        
        $query = Observation::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "OBSERVATION_REFERENCE_NO") {
                    //$query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                    $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "OBS_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "OBS_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        // if (strtoupper($tab) == "PENDING") {
        //     if ($userRoles == 11) {
        //         $query->whereIn('STAGE_ID', [6,7]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 12) {
        //         $query->whereIn('STAGE_ID', [2,3,4,5,8,9,10]);
        //     }
        // } elseif (strtoupper($tab) == "REVIEWED") {
        //     if ($userRoles == 11) {
        //         $query->whereIn('STAGE_ID', [2,3,4,5,8,9,10]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 12) {
        //         $query->whereIn('STAGE_ID', [6,7,8]);
        //     }
        // }elseif(strtoupper($tab) == "DRAFT"){
        //     if ($userRoles == 11) {
        //         $query->whereIn('STAGE_ID', [1]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     }
        // }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);


        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        return $query->paginate($this->pageSize, ['*'], 'page', $this->page);
    }

    public function getObservationListTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        // $tab = $requestData->TAB ?? "PENDING";
        $query = Observation::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage'];

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "OBS")->pluck("ROLE_ID")->first();

        // if(!empty($requestData->STAGE_ID)){
        //     $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        // }


        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "OBSERVATION_REFERENCE_NO") {
                   // $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                   $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "OBS_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "OBS_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        // if (strtoupper($tab) == "PENDING") {
        //     if ($userRoles == 11) {
        //         $query->whereIn('STAGE_ID', [6,7]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 12) {
        //         $query->whereIn('STAGE_ID', [2,3,4,5,8,9,10]);
        //     }
        // } elseif (strtoupper($tab) == "REVIEWED") {
        //     if ($userRoles == 11) {
        //         $query->whereIn('STAGE_ID', [2,3,4,5,8,9,10]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 12) {
        //         $query->whereIn('STAGE_ID', [6,7,8]);
        //     }
        // }elseif(strtoupper($tab) == "DRAFT"){
        //     if ($userRoles == 11) {
        //         $query->whereIn('STAGE_ID', [1]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     }
        // }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->count();
    }
}