<?php

namespace App\Services\Report;

use App\Http\Resources\Report\ReportInspectionResource;
use App\Models\MstSite;
use App\Models\Inspection;
use App\Models\InspectionActionHistory;
use App\Models\InspectionMapCaptcha;
use App\Models\InspectionMapChecklist;
use App\Models\InspectionMapDeclaration;
use App\Models\InspectionMapFiles;
use App\Models\InspectionMapHira;
use App\Models\InspectionMapPrecautions;
use App\Models\InspectionMapSopPolicies;
use App\Models\InspectionMapSopPolicy;
use App\Models\InspectionMapRecipent;
use App\Models\InspectionMstChecklist;
use App\Models\InspectionMstChecklistOption;
use App\Models\InspectionMstDeclaration;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\InspectionMstType;
use App\Models\MstLocation;
use App\Models\HiraMstLocation;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ReportInspectionServices extends ReportInspectionResource
{
    public $vvsInspectionModel;
    public $page;
    public $pageSize;
    public function __construct()
    {
        $this->vvsInspectionModel = new Inspection();
    }
    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'TYPE_ID' => 'TYPE_ID',
            'SITE_ID' => 'SITE_ID',
            'INSPECTION_REFERENCE_NO' => 'ID',
            'LOCATION_ID' => 'LOCATION_ID',
            'INSP_START_TIME'=>'INSP_START_TIME',
            'INSP_END_TIME'=>'INSP_END_TIME',
            'STAGE_ID'=>'STAGE_ID'
        ];
    }

    // protected function mapRoleStageTab($requestData,$roleId){
    //     $tab = strtoupper($requestData->TAB);
    //     $stageId = (!empty( $requestData ->STAGE_ID)) ? $requestData ->STAGE_ID : "";
    //     if( $stageId == "" &&  $tab == "DRAFT") $tab = "DRAFT";
    //     else if($stageId){

    //         if( $stageId == 1 ){
    //             if($roleId == 7) $tab = "DRAFT";
    //         }
    //         else if( $stageId == 2 ){
    //             if($roleId == 7) $tab = "REVIEWED";
    //             else if($roleId == 8) $tab = "REVIEWED";
    //             else if($roleId == 9) $tab = "REVIEWED";
    //         }            
    //     }
        
    //     return $tab;
    // }

    // public function calculatedTab($requestData){
    //     $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "INSP")->pluck("ROLE_ID")->first();
    //     return $this -> mapRoleStageTab($requestData,$userRoles);
    // }
    public function getInspectionList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        // $tab = strtoupper($requestData->TAB) ?? "DRAFT";

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "INSP")->pluck("ROLE_ID")->first();


        // if(!empty($requestData->STAGE_ID)){
        //     $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        // }

        $query = Inspection::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location','stage'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "INSPECTION_REFERENCE_NO") {
                    //$query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                    $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "INSP_START_TIME") {
                    $query->whereDate('INSP_DATE', '>=',$value);
                }
                else if ($columnMapping[$key] == "INSP_END_TIME") {
                    $query->whereDate('INSP_DATE', '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        // if (strtoupper($tab) == "REVIEWED") {
        //     if ($userRoles == 7) {
        //         $query->whereIn('STAGE_ID', [2]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 8) {
        //         $query->whereIn('STAGE_ID', [2]);
        //     } elseif ($userRoles == 9) {
        //         $query->whereIn('STAGE_ID', [2]);
        //     }
        // }elseif(strtoupper($tab) == "DRAFT"){
        //     if ($userRoles == 7) {
        //         $query->whereIn('STAGE_ID', [1]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     }
        // }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);


        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        return $query->paginate($this->pageSize, ['*'], 'page', $this->page);
    }
    public function getInspectionListTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        // $tab = strtoupper($requestData->TAB) ?? "DRAFT";
        $query = Inspection::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location', 'stage'];

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "INSP")->pluck("ROLE_ID")->first();

        // if(!empty($requestData->STAGE_ID)){
        //     $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        // }


        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "INSPECTION_REFERENCE_NO") {
                    //$query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                    $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "INSP_START_TIME") {
                    $query->whereDate('INSP_DATE', '>=',$value);
                }
                else if ($columnMapping[$key] == "INSP_END_TIME") {
                    $query->whereDate('INSP_DATE', '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        // if (strtoupper($tab) == "REVIEWED") {
        //     if ($userRoles == 7) {
        //         $query->whereIn('STAGE_ID', [2]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 8) {
        //         $query->whereIn('STAGE_ID', [2]);
        //     } elseif ($userRoles == 9) {
        //         $query->whereIn('STAGE_ID', [2]);
        //     }
        // }elseif(strtoupper($tab) == "DRAFT"){
        //     if ($userRoles == 7) {
        //         $query->whereIn('STAGE_ID', [1]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     }
        // }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->count();
    }
}