<?php

namespace App\Services\Report;
use App\Http\Resources\Report\ReportHiraResource;
use App\Models\MstSite;
use App\Models\HiraMstStage;
use App\Models\Hira;
use App\Models\HiraActivity;
use App\Models\HiraMapControlInPlace;
use App\Models\HiraMapRefDoc;
use App\Models\HiraMapDeclaration;
use App\Models\HiraMstDeclaration;
use App\Models\HiraActionHistory;
use App\Models\HiraMapActivityType;
use App\Models\User;
use App\Models\MstLocation;
use App\Models\UserMapRole;
use App\Models\HiraMstJob;
use App\Models\HiraMstRiskRelated;
use App\Models\HiraMstSeverity;
use App\Models\HiraMstLikelihood;
use App\Models\PtwMstType;
use App\Models\HiraMstActivity;
use App\Models\HiraAuditLog;
use App\Models\HiraChangeLog;
use App\Models\HiraMstLocation;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ReportHiraServices extends ReportHiraResource
{
    public $vvsHiraModel;
    public function __construct()
    {
        $this->vvsHiraModel = new Hira();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'HIRA_REFERENCE_NO' => 'HIRA_REFERENCE_NO',
            'LOCATION_ID' => 'LOCATION_ID',
            'HIRA_START_DATE'=>'HIRA_START_DATE',
            'HIRA_END_DATE'=>'HIRA_END_DATE',
            'STAGE_ID'=>'STAGE_ID'
        ];
    }

    //code
    // protected function mapRoleStageTab($requestData,$roleId){
    //     $tab = $requestData->TAB;
    //     $stageId = (!empty( $requestData ->STAGE_ID)) ? $requestData ->STAGE_ID : "";
    //     if( $stageId == "" &&  $tab == "DRAFT") $tab = "DRAFT";
    //     else if($stageId){

    //         if( $stageId == 1 ){
    //             if($roleId == 4) $tab = "DRAFT";
    //         }
    //         else if( $stageId == 3 ){
    //             if($roleId == 4) $tab = "REVIEWED";
    //             else if($roleId == 5) $tab = "REVIEWED";
    //             else if($roleId == 6) $tab = "PENDING";
    //             else if(!in_array($roleId,[4,5,6])) $tab = "";
    //         }
    //         else if( $stageId == 2 ){
    //             if($roleId == 4) $tab = "REVIEWED";
    //             else if($roleId == 5) $tab = "PENDING";
    //             else if($roleId == 6) $tab = "";
    //             else if(!in_array($roleId,[4,5,6])) $tab = "";
    //         }
    //         else if( $stageId == 4){
    //             if($roleId == 4) $tab = "PENDING";
    //             else if($roleId == 5) $tab = "REVIEWED";
    //             else if($roleId == 6) $tab = "";
    //             else if(!in_array($roleId,[4,5,6])) $tab = "";
    //         }
    //         else if( $stageId == 5){
    //             if($roleId == 4) $tab = "PENDING";
    //             else if($roleId == 5) $tab = "REVIEWED";
    //             else if($roleId == 6) $tab = "REVIEWED";
    //             else if(!in_array($roleId,[4,5,6]) && $stageId == 5) $tab = "PENDING";
    //         }
    //         else if($stageId == 6){
    //             if($roleId == 4) $tab = "REVIEWED";
    //             else if($roleId == 5) $tab = "PENDING";
    //             else if($roleId == 6) $tab = "REVIEWED";
    //             else if(!in_array($roleId,[4,5,6]) && $stageId == 6) $tab = "";
    //         }            
    //         else if( $stageId == 7 ||  $stageId == 8 ||  $stageId == 9){
    //             if($roleId == 4) $tab = "REVIEWED";
    //             else if($roleId == 5) $tab = "REVIEWED";
    //             else if($roleId == 6) $tab = "REVIEWED";
    //             else if(!in_array($roleId,[4,5,6])) $tab = "REVIEWED";
    //         }
    //     }
        
    //     return $tab;
    // }

    // public function calculatedTab($requestData){
    //     $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
    //                 ->where("MODULE_NAME", "HIRA")->pluck("ROLE_ID")->first();
    //     return $this -> mapRoleStageTab($requestData,$userRoles);
    // }
    
    public function getHiraList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        // $tab = $requestData->TAB ?? "PENDING";

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "HIRA")->pluck("ROLE_ID")->first();
        
        // if(!empty($requestData->STAGE_ID)){
        //     $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        // }        
        $query = Hira::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "HIRA_REFERENCE_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "HIRA_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "HIRA_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        // if (strtoupper($tab) == "PENDING") { 
        //     if ($userRoles == 4) {
        //         $query->whereIn('STAGE_ID', [4,5]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 5) {
        //         $query->whereIn('STAGE_ID', [2,6]);
        //     } elseif ($userRoles == 6) {                
        //         $query->whereIn('STAGE_ID', [3]);               
        //     }else if(!in_array($userRoles,[4,5,6])){
        //         $activitylist = HiraActivity::where('IS_ACTIVE',1)->where('IS_DELETED',0)->where('STAGE_ID',1)
        //         ->where('ACTION_OWNER_ID',$requestData->CREATED_BY)->pluck('HIRA_ID')->unique()->toArray();
        //         $activitylist = array_unique($activitylist);
        //         $query->where(function($query3) use ($activitylist) {                   
        //             $query3->whereIn('STAGE_ID', [3]);
        //             $query3->orWhere(function($query3) use ($activitylist) {
        //                 $query3->whereIn('STAGE_ID', [5]);
        //                 $query3->whereIn('ID', $activitylist);
        //             });                   
        //         });
        //     }
        // } elseif (strtoupper($tab) == "REVIEWED") {
        //     if ($userRoles == 4) {
        //         $query->whereIn('STAGE_ID', [2,6,7,8,9]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 5) {
        //         $query->whereIn('STAGE_ID', [3,4,5,7,8,9]);
        //     } elseif ($userRoles == 6) {
        //         $query->whereIn('STAGE_ID', [5,6,7,8,9]);
        //     }else if(!in_array($userRoles,[4,5,6])){
        //         $activitylist = HiraActivity::where('IS_ACTIVE',1)->where('IS_DELETED',0)->where('STAGE_ID',2)
        //         ->where('ACTION_OWNER_ID',$requestData->CREATED_BY)->pluck('HIRA_ID')->unique()->toArray();
        //         $activitylist = array_unique($activitylist);
        //         $query->where(function($query3) use ($activitylist) {                   
        //             $query3->whereIn('STAGE_ID', [3]);
        //             $query3->orWhere(function($query3) use ($activitylist) {
        //                 $query3->whereIn('STAGE_ID', [5]);
        //                 $query3->whereIn('ID', $activitylist);
        //             });                   
        //         });
        //     }
        // }elseif(strtoupper($tab) == "DRAFT"){
        //     if ($userRoles == 4) {
        //         $query->whereIn('STAGE_ID', [1]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     }
        // }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);


        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        return $query->paginate($this->pageSize, ['*'], 'page', $this->page);
    }

    public function getHiraListTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        // $tab = $requestData->TAB ?? "PENDING";
        $query = Hira::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage'];

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "HIRA")->pluck("ROLE_ID")->first();

        // if(!empty($requestData->STAGE_ID)){
        //     $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        // }


        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "HIRA_REFERENCE_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "HIRA_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "HIRA_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        // if (strtoupper($tab) == "PENDING") {            
        //     if ($userRoles == 4) {
        //         $query->whereIn('STAGE_ID', [4,5]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 5) {               
        //         $query->whereIn('STAGE_ID', [2,6]);               
        //     } elseif ($userRoles == 6) {               
        //         $query->whereIn('STAGE_ID', [3]);               
        //     }else if(!in_array($userRoles,[4,5,6])){
        //         $activitylist = HiraActivity::where('IS_ACTIVE',1)->where('IS_DELETED',0)->where('STAGE_ID',1)
        //         ->where('ACTION_OWNER_ID',$requestData->CREATED_BY)->pluck('HIRA_ID')->unique()->toArray();
        //         $activitylist = array_unique($activitylist);
        //         $query->where(function($query3) use ($activitylist) {                   
        //             $query3->whereIn('STAGE_ID', [3]);
        //             $query3->orWhere(function($query3) use ($activitylist) {
        //                 $query3->whereIn('STAGE_ID', [5]);
        //                 $query3->whereIn('ID', $activitylist);
        //             });                   
        //         });
        //     }
        // } elseif (strtoupper($tab) == "REVIEWED") {
        //     if ($userRoles == 4) {
        //         $query->whereIn('STAGE_ID', [2,6,7,8,9]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     } elseif ($userRoles == 5) {
        //         $query->whereIn('STAGE_ID', [3,4,5,7,8,9]);
        //     } elseif ($userRoles == 6) {
        //         $query->whereIn('STAGE_ID', [5,6,7,8,9]);
        //     }else if(!in_array($userRoles,[4,5,6])){
        //         $activitylist = HiraActivity::where('IS_ACTIVE',1)->where('IS_DELETED',0)->where('STAGE_ID',2)
        //         ->where('ACTION_OWNER_ID',$requestData->CREATED_BY)->pluck('HIRA_ID')->unique()->toArray();
        //         $activitylist = array_unique($activitylist);
        //         $query->where(function($query3) use ($activitylist) {                   
        //             $query3->whereIn('STAGE_ID', [3]);
        //             $query3->orWhere(function($query3) use ($activitylist) {
        //                 $query3->whereIn('STAGE_ID', [5]);
        //                 $query3->whereIn('ID', $activitylist);
        //             });                   
        //         });
        //     }
        // }elseif(strtoupper($tab) == "DRAFT"){
        //     if ($userRoles == 4) {
        //         $query->whereIn('STAGE_ID', [1]);
        //         $query->where("CREATED_BY", $requestData->CREATED_BY);
        //     }
        // }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->count();
    }
}