<?php

namespace App\Services\PTW;

use App\Http\Requests\PTW\AddRequest;
use App\Http\Resources\PTW\PtwResource;
use App\Models\MstSite;
use App\Models\Ptw;
use App\Models\User;
use App\Models\UserMapRole;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;

class PtwSendMailServices extends PtwResource
{
    public $vvsPtwModel;    
    public function __construct()
    {
        $this->vvsPtwModel = new Ptw();
    }

    public function ptwSendMail($stage_id,$ptw_id){
        if($stage_id == 2 || $stage_id == 3){
            $this->sendApprovalMail($ptw_id);
        }
        if($stage_id == 4){
            $this->sendSendBackMail($ptw_id);
        }
        if($stage_id == 5){
            $this->sendApprovedMail($ptw_id);
        }
        if($stage_id == 7){
            $this->sendCloseRequestMail($ptw_id);
        }
        if($stage_id == 8){
            $this->sendClosedMail($ptw_id);
        }
        if($stage_id == 11){
            $this->sendSuspendedMail($ptw_id);
        }
        if($stage_id == 13){
            $this->sendRenewedMail($ptw_id);
        }
    }

    protected function getPtwUserList($site_id,$role_id) {
        return User::select(
            'USERS.ID', 
            'USERS.FIRST_NAME', 
            'USERS.LAST_NAME', 
            'USERS.EMAIL',
            'MST_ROLE.ROLE_NAME'            
            )
            ->leftJoin('USERS_MAP_ROLE', 'USERS_MAP_ROLE.USER_ID', '=', 'USERS.ID')
            ->leftJoin('USERS_MAP_SITE', 'USERS_MAP_SITE.USER_ID', '=', 'USERS.ID')
            ->leftJoin('MST_ROLE', 'USERS_MAP_ROLE.ROLE_ID', '=', 'MST_ROLE.ROLE_ID')                                  
            ->where("USERS_MAP_SITE.SITE_ID",$site_id)
            ->where("USERS_MAP_ROLE.MODULE_NAME","PTW")
            ->where("USERS_MAP_ROLE.ROLE_ID",$role_id)
            ->where("USERS.IS_ACTIVE",1)
            ->where("USERS.IS_DELETED",0)
            ->where("USERS_MAP_ROLE.IS_ACTIVE",1)
            ->where("USERS_MAP_ROLE.IS_DELETED",0)
            ->where("USERS_MAP_SITE.IS_ACTIVE",1)
            ->where("USERS_MAP_SITE.IS_DELETED",0)
            ->where("MST_ROLE.IS_ACTIVE",1)
            ->where("MST_ROLE.IS_DELETED",0)            
            ->get();    
    }

    protected function sendApprovalMail($ptw_id){
        $ptwdetails = Ptw::where("ID", $ptw_id)->first();
        $preparedBy = $ptwdetails->preparedby;
        $mapRole = $preparedBy->ptwroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:blue;">PTW PENDING FOR REVIEWER / APPROVAL</h1></p>';
        $mailBody.="<p>The Permit to Work (PTW) as referred below has been submitted by 
        ".$this->customDecrypt($ptwdetails->preparedby->FIRST_NAME).' '.$this->customDecrypt($ptwdetails->preparedby->LAST_NAME)." [".$roleName."] 
        and now pending for your Review / approval.
        </p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$ptwdetails->AUTO_GEN_REF_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($ptwdetails->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")).
        ' - '.showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$ptwdetails->type->TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>PTW Details:</td><td>'.$ptwdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>Activity location:</td><td>'.$ptwdetails->location->LOCATION_NAME.'</td></tr>';
        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';        
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";

        if($ptwdetails->STAGE_ID == 3){
            $userlist = $this->getPtwUserList($ptwdetails->SITE_ID,3);
        }else{
            $userlist = $this->getPtwUserList($ptwdetails->SITE_ID,2);
        }        
        foreach($userlist as $value){
            $to_email = $this->customDecrypt($value->EMAIL);            
            $data = array('body' => $mailBody,'to_email'=>$to_email);
            Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('PTW PENDING FOR REVIEWER / APPROVAL');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
            });
        }
    }

    protected function sendSendBackMail($ptw_id){
        $ptwdetails = Ptw::where("ID", $ptw_id)->first();
        $firstRejectedHistory = $ptwdetails->actionRejectedHistory->first();
        $actionTracker = $firstRejectedHistory->actionTracker;
        $mapRole = $actionTracker->ptwroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:red;">PTW SENT FOR CORRECTION</h1></p>';
        $mailBody.="<p>The Permit to Work (PTW) as referred below has been rejected by ".$this->customDecrypt($actionTracker->FIRST_NAME) . " " . $this->customDecrypt($actionTracker->LAST_NAME)." [".$roleName."]
         and now pending for necessary correction and resubmission.</p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$ptwdetails->AUTO_GEN_REF_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($ptwdetails->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")).
        ' - '.showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$ptwdetails->type->TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>PTW Details:</td><td>'.$ptwdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>Activity location:</td><td>'.$ptwdetails->location->LOCATION_NAME.'</td></tr>';

        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $to_email = $this->customDecrypt($ptwdetails->preparedby->EMAIL);
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('PTW SENT FOR CORRECTION');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

    protected function sendApprovedMail($ptw_id){
        $ptwdetails = Ptw::where("ID", $ptw_id)->first();
        $approvedData = $ptwdetails->approvedby->first();
        $approvedBy = $approvedData->actionTracker;
        $mapRole = $approvedBy->ptwroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $approvedByName = $this->customDecrypt($approvedData->actionTracker->FIRST_NAME).' '.$this->customDecrypt($approvedData->actionTracker->LAST_NAME);
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:green;">PTW APPROVED</h1></p>';
        $mailBody.="<p>The Permit to Work (PTW) as referred below has been approved by ".$approvedByName." [".$roleName."].</p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$ptwdetails->AUTO_GEN_REF_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($ptwdetails->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")).
        ' - '.showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$ptwdetails->type->TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>PTW Details:</td><td>'.$ptwdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>Activity location:</td><td>'.$ptwdetails->location->LOCATION_NAME.'</td></tr>';

        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $to_email = $this->customDecrypt($ptwdetails->preparedby->EMAIL);
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
            $message->to($data['to_email']);
            $message->subject('PTW APPROVED');
            $message->html($data['body']);
            $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

    protected function sendCloseRequestMail($ptw_id){
        $ptwdetails = Ptw::where("ID", $ptw_id)->first();
        $closedReqData = $ptwdetails->closedrequestby->first();
        $closedBy = $closedReqData->actionTracker;
        $mapRole = $closedBy->ptwroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $closedReqBy = $this->customDecrypt($closedReqData->actionTracker->FIRST_NAME).' '.$this->customDecrypt($closedReqData->actionTracker->LAST_NAME);
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1  style="color:blue;">PTW CLOSURE REQUESTED</h1></p>';
        $mailBody.="<p>The Permit to Work (PTW) as referred below has been requested to be closed by ".$closedReqBy." 
        [".$roleName."] and now pending for your Action.</p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$ptwdetails->AUTO_GEN_REF_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($ptwdetails->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")).
        ' - '.showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$ptwdetails->type->TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>PTW Details:</td><td>'.$ptwdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>Activity location:</td><td>'.$ptwdetails->location->LOCATION_NAME.'</td></tr>';

        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";

        $userlist = $this->getPtwUserList($ptwdetails->SITE_ID,2);
        foreach($userlist as $value){
            $to_email = $this->customDecrypt($value->EMAIL);
            $data = array('body' => $mailBody,'to_email'=>$to_email);
            Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('PTW CLOSURE REQUESTED');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
            });
        }
    }

    protected function sendClosedMail($ptw_id){
        $ptwdetails = Ptw::where("ID", $ptw_id)->first();
        $closedData = $ptwdetails->closedby->first();
        $closedBy = $closedData->actionTracker;
        $mapRole = $closedBy->ptwroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $closedBy = $this->customDecrypt($closedData->actionTracker->FIRST_NAME).' '.$this->customDecrypt($closedData->actionTracker->LAST_NAME);
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:green;">PTW CLOSED</h1></p>';
        $mailBody.="<p>The Permit to Work (PTW) as referred below has been closed by ".$closedBy." [".$roleName."].</p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$ptwdetails->AUTO_GEN_REF_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($ptwdetails->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")).
        ' - '.showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$ptwdetails->type->TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>PTW Details:</td><td>'.$ptwdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>Activity location:</td><td>'.$ptwdetails->location->LOCATION_NAME.'</td></tr>';

        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $userlist = $this->getPtwUserList($ptwdetails->SITE_ID,1);
        $to_email = $this->customDecrypt($ptwdetails->preparedby->EMAIL);
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
            $message->to($data['to_email']);
            $message->subject('PTW CLOSED');
            $message->html($data['body']);
            $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

    protected function sendRenewedMail($ptw_id){
        $ptwdetails = Ptw::where("ID", $ptw_id)->first();
        $preparedBy = $ptwdetails->preparedby;
        $mapRole = $preparedBy->ptwroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1  style="color:blue;">PTW RENEWED</h1></p>';
        $mailBody.="<p>The Permit to Work (PTW) as referred below has been Renewed by ".$this->customDecrypt($ptwdetails->preparedby->FIRST_NAME).
        ' '.$this->customDecrypt($ptwdetails->preparedby->LAST_NAME)." [".$roleName."] and now pending for your Review / approval.</p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$ptwdetails->AUTO_GEN_REF_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($ptwdetails->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")).
        ' - '.showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$ptwdetails->type->TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>PTW Details:</td><td>'.$ptwdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>Activity location:</td><td>'.$ptwdetails->location->LOCATION_NAME.'</td></tr>';

        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $userlist = $this->getPtwUserList($ptwdetails->SITE_ID,2);
        foreach($userlist as $value){
            $to_email = $this->customDecrypt($value->EMAIL);
            $data = array('body' => $mailBody,'to_email'=>$to_email);
            Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('PTW RENEWED');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
            });
        }
    }

    protected function sendSuspendedMail($ptw_id){
        $ptwdetails = Ptw::where("ID", $ptw_id)->first();
        $suspendData = $ptwdetails->suspendby->first();
        $suspendBy = $suspendData->actionTracker;
        $mapRole = $suspendBy->ptwroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $suspendBy = $this->customDecrypt($suspendData->actionTracker->FIRST_NAME).' '.$this->customDecrypt($suspendData->actionTracker->LAST_NAME);
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:red;">PTW SUSPENDED</h1></p>';
        $mailBody.="<p>The Permit to Work (PTW) as referred below has been Suspended by ".$suspendBy." [".$roleName."].
        </p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$ptwdetails->AUTO_GEN_REF_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($ptwdetails->PERMIT_START_TIME, config("constants.DATE_TIME_FORMAT")).
        ' - '.showDate($ptwdetails->PERMIT_END_TIME, config("constants.DATE_TIME_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$ptwdetails->type->TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>PTW Details:</td><td>'.$ptwdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>Activity location:</td><td>'.$ptwdetails->location->LOCATION_NAME.'</td></tr>';

        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $userlist = $this->getPtwUserList($ptwdetails->SITE_ID,1);
        $to_email = $this->customDecrypt($ptwdetails->preparedby->EMAIL);
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
            $message->to($data['to_email']);
            $message->subject('PTW SUSPENDED');
            $message->html($data['body']);
            $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

}
