<?php

namespace App\Services\PTW;

use App\Http\Resources\PTW\PtwMstDeclarationResource;
use App\Models\PtwMapDeclaration;
use App\Models\PtwMstDeclaration;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;

class PtwMstDeclarationServices extends PtwMstDeclarationResource
{
    public $vvsPtwDeclModel;
    public function __construct(){
        $this->vvsPtwDeclModel = new PtwMstDeclaration();
    }
    

    public function getPtwInitialDeclListOne(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%PTW_ADD_ONE%')->get();
    }

    public function getPtwInitialDeclListTwo(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%PTW_ADD_TWO%')->get();
    }

    public function getPtwMoveFrwdDeclList(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%MOVE_FORWARD%')->get();
    }

    public function getPtwApproveDeclList(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%APPROVE%')->get();
    }

    public function getPtwRejectDeclList(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%REJECT%')->get();
    }

    public function getPtwCloseReqDeclList(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%REQUEST_FOR_CLOSURE%')->get();
    }

    public function getPtwCloseDeclList(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%CLOSE%')->get();
    }

    public function getPtwSuspendReqDeclList(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%REQUEST_FOR_SUSPEND%')->get();
    }

    public function getPtwSuspendDeclList(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', 'SUSPEND%')->get();
    }

    public function getPtwRenewDeclList(){
        return PtwMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', 'RENEWED%')->get();
    }

    public function getMapDeclarationOne($ptw_id,$afterSubmit){
        if( $afterSubmit == 1 ){

            return PtwMstDeclaration::select(
                        'PTW_MST_DECLARATION.DECLARATION_ID', 
                        'PTW_MST_DECLARATION.DECLARATION_NAME', 
                        'PTW_MST_DECLARATION.DECLARATION_GROUP', 
                        'PTW_MST_DECLARATION.DECLARATION_SECTION',
                        'PTW_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                        'PTW_MAP_DECLARATION.MAP_DECLARATION_ID',
                        'PTW_MAP_DECLARATION.IS_ACTIVE',
                        'PTW_MAP_DECLARATION.IS_DELETED'
                    )
                    ->leftJoin('PTW_MAP_DECLARATION', function($join) use ($ptw_id) {
                        $join->on('PTW_MAP_DECLARATION.DECLARATION_ID', '=', 'PTW_MST_DECLARATION.DECLARATION_ID')
                            ->where('PTW_MAP_DECLARATION.PTW_ID', $ptw_id)
                            ->where('PTW_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('PTW_MAP_DECLARATION.IS_DELETED', 0);
                    })
                    ->where('PTW_MST_DECLARATION.IS_ACTIVE', 1)
                    ->where('PTW_MST_DECLARATION.IS_DELETED', 0)                    
                    ->where('PTW_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', 'PTW_ADD_ONE%')
                    ->get();
        }else{
            return PtwMapDeclaration::select('PTW_MST_DECLARATION.DECLARATION_ID', 'PTW_MST_DECLARATION.DECLARATION_NAME', 'PTW_MST_DECLARATION.DECLARATION_GROUP', 'PTW_MST_DECLARATION.DECLARATION_SECTION','PTW_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                                            'PTW_MAP_DECLARATION.MAP_DECLARATION_ID',
                                            'PTW_MAP_DECLARATION.IS_ACTIVE',
                                            'PTW_MAP_DECLARATION.IS_DELETED'
                                            )
                            ->leftJoin('PTW_MST_DECLARATION', 'PTW_MAP_DECLARATION.DECLARATION_ID', '=', 'PTW_MST_DECLARATION.DECLARATION_ID')
                            //->where('PTW_MST_DECLARATION.IS_ACTIVE', 1)
                            ->where('PTW_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('PTW_MAP_DECLARATION.IS_DELETED', 0)
                            //->where('PTW_MST_DECLARATION.IS_DELETED', 0)
                            ->where("PTW_MAP_DECLARATION.PTW_ID",$ptw_id)
                            ->where('PTW_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', '%PTW_ADD_ONE%')
                            ->get();
                  
        }
        // prd($hi );
        // }
        // $query1= DB::table(DB::raw('public."PTW_MAP_DECLARATION"'))
        //             ->select(DB::raw('PTW_ID,DECLARATION_ID'))
        //             ->where('IS_DELETED', 0)
        //             ->where('PTW_ID', $ptw_id);
        // $sql1Query1 = getQueryWithBindings($query1->toSql(),$query1->getBindings());

        // $query2= DB::table(DB::raw('public."PTW_MST_DECLARATION" dm1'))
        //             ->select(DB::raw('dm1.DECLARATION_ID,DECLARATION_NAME,DECLARATION_SECTION,DECLARATION_GROUP,
        //             IS_MANDATORY_DURING_ADD'))
        //             ->leftJoin(DB::raw("(".$sql1Query1.") dm"), function ($join) {
        //                 $join->on("dm1.DECLARATION_ID", "=", "dm.DECLARATION_ID");
        //             })
        //             ->where('dm1.IS_DELETED', 0)
        //             ->where('DECLARATION_SECTION', 'LIKE', '%PTW_ADD_ONE%');
        // if($afterSubmit == 1){
        //     $query2->whereRaw("dm.PTW_ID IS NOT NULL");
        // }
        // $sql1Query2 = getQueryWithBindings($query2->toSql(),$query2->getBindings());prd($sql1Query2);
        // return $query2->get();
    }

    public function getMapDeclarationTwo($ptw_id,$afterSubmit){
        if( $afterSubmit == 1 ){

               return PtwMstDeclaration::select(
                    'PTW_MST_DECLARATION.DECLARATION_ID', 
                    'PTW_MST_DECLARATION.DECLARATION_NAME', 
                    'PTW_MST_DECLARATION.DECLARATION_GROUP', 
                    'PTW_MST_DECLARATION.DECLARATION_SECTION',
                    'PTW_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                    'PTW_MAP_DECLARATION.MAP_DECLARATION_ID',
                    'PTW_MAP_DECLARATION.IS_ACTIVE',
                    'PTW_MAP_DECLARATION.IS_DELETED'
                )
                ->leftJoin('PTW_MAP_DECLARATION', function($join) use ($ptw_id) {
                    $join->on('PTW_MAP_DECLARATION.DECLARATION_ID', '=', 'PTW_MST_DECLARATION.DECLARATION_ID')
                         ->where('PTW_MAP_DECLARATION.PTW_ID', $ptw_id)
                         ->where('PTW_MAP_DECLARATION.IS_ACTIVE', 1)
                         ->where('PTW_MAP_DECLARATION.IS_DELETED', 0);
                })
                ->where('PTW_MST_DECLARATION.IS_ACTIVE', 1)
                ->where('PTW_MST_DECLARATION.IS_DELETED', 0)
                ->where('PTW_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', 'PTW_ADD_TWO%')
                ->get();
        }else{
            return PtwMapDeclaration::select('PTW_MST_DECLARATION.DECLARATION_ID', 'PTW_MST_DECLARATION.DECLARATION_NAME', 'PTW_MST_DECLARATION.DECLARATION_GROUP', 'PTW_MST_DECLARATION.DECLARATION_SECTION','PTW_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                                            'PTW_MAP_DECLARATION.MAP_DECLARATION_ID',
                                            'PTW_MAP_DECLARATION.IS_ACTIVE',
                                            'PTW_MAP_DECLARATION.IS_DELETED'
                                            )
                            ->Join('PTW_MST_DECLARATION', 'PTW_MAP_DECLARATION.DECLARATION_ID', '=', 'PTW_MST_DECLARATION.DECLARATION_ID')
                            ->where('PTW_MST_DECLARATION.IS_ACTIVE', 1)
                            ->where('PTW_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('PTW_MAP_DECLARATION.IS_DELETED', 0)
                            ->where('PTW_MST_DECLARATION.IS_DELETED', 0)
                            ->where("PTW_MAP_DECLARATION.PTW_ID",$ptw_id)
                            ->where('PTW_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', '%PTW_ADD_TWO%')
                            ->get();
                  
        }
        
        
        // $query1= DB::table('public."PTW_MAP_DECLARATION"')
        //             ->select(DB::raw('PTW_ID,DECLARATION_ID'))
        //             ->where('IS_DELETED', 0)
        //             ->where('PTW_ID', $ptw_id);
        // $sql1Query1 = getQueryWithBindings($query1->toSql(),$query1->getBindings());

        // $query2= DB::table('public."PTW_MST_DECLARATION" dm1')
        //             ->select(DB::raw('dm1.DECLARATION_ID,DECLARATION_NAME,DECLARATION_SECTION,DECLARATION_GROUP,
        //             IS_MANDATORY_DURING_ADD'))
        //             ->leftJoin(DB::raw("(".$sql1Query1.") dm"), function ($join) {
        //                 $join->on("dm1.DECLARATION_ID", "=", "dm.DECLARATION_ID");
        //             })
        //             ->where('dm1.IS_DELETED', 0)
        //             ->where('DECLARATION_SECTION', 'LIKE', '%PTW_ADD_TWO%');
        // if($afterSubmit == 1){
        //     $query2->whereRaw("dm.PTW_ID IS NOT NULL");
        // }
        // //$sql1Query2 = getQueryWithBindings($query2->toSql(),$query2->getBindings());
        // return $query2->get();
    }

    public function getMapDeclarationAll($ptw_id){
        return PtwMapDeclaration::select(            
            'PTW_MST_DECLARATION.DECLARATION_NAME', 
            'PTW_MST_DECLARATION.DECLARATION_GROUP', 
            'PTW_MST_DECLARATION.DECLARATION_SECTION'            
        )
        ->Join('PTW_MST_DECLARATION', 'PTW_MAP_DECLARATION.DECLARATION_ID', '=', 'PTW_MST_DECLARATION.DECLARATION_ID')
        ->where('PTW_MST_DECLARATION.IS_ACTIVE', 1)
        ->where('PTW_MAP_DECLARATION.IS_ACTIVE', 1)
        ->where('PTW_MAP_DECLARATION.IS_DELETED', 0)
        ->where('PTW_MST_DECLARATION.IS_DELETED', 0)
        ->where("PTW_MAP_DECLARATION.PTW_ID",$ptw_id)        
        ->get();
    }
    
}
