<?php

namespace App\Services\OBSERVATION;
use App\Http\Requests\OBSERVATION\AddRequest;
use App\Http\Resources\OBSERVATION\ObservationResource;
use App\Models\MstSite;
use App\Models\Observation;
use App\Models\ObservationActionHistory;
use App\Models\ObservationMapDeclaration;
use App\Models\ObservationMapFile;
use App\Models\ObservationMstDeclaration;
use App\Models\ObservationMstStage;
use App\Models\ObservationMstType;
use App\Models\HiraMstLocation;
use App\Models\ObservationActionTakenDetailsLog;
use App\Models\ObservationMapDeclarationForM;
use App\Services\OBSERVATION\ObservationSendMailServices;
use App\Http\Traits\EncDecService;

use App\Models\User;
use App\Models\UserMapRole;

use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ObservationServices extends ObservationResource
{
    use EncDecService;
    public $vvsObservationModel;
    public $vvsObsSendMailService;
    public function __construct()
    {
        $this->vvsObservationModel = new Observation();
        $this->vvsObsSendMailService = new ObservationSendMailServices();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'OBSERVATION_REFERENCE_NO' => 'ID',
            'LOCATION_ID' => 'LOCATION_ID',
            'TYPE_ID' => 'OBS_TYPE_ID',
            'OBS_START_DATE'=>'OBS_START_DATE',
            'OBS_END_DATE'=>'OBS_END_DATE',
            'STAGE_ID'=>'STAGE_ID'
        ];
    }

    //code
    protected function mapRoleStageTab($requestData,$roleId){
        $tab = $requestData->TAB;
        $stageId = (!empty( $requestData ->STAGE_ID)) ? $requestData ->STAGE_ID : "";
        if( $stageId == "" &&  $tab == "DRAFT") $tab = "DRAFT";
        if( $roleId == 10 ) $tab = "REVIEWED";
        else if($stageId){

            if( $stageId == 1 ){
                if($roleId == 11) $tab = "DRAFT";
            }
            else if( $stageId == 3 ){
                if($roleId == 11) $tab = "REVIEWED";
                else if($roleId == 12) $tab = "REVIEWED";
                else if($roleId == 10) $tab = "REVIEWED";                
            }
            else if( $stageId == 2 ){
                if($roleId == 11) $tab = "REVIEWED";
                else if($roleId == 12) $tab = "PENDING";
                else if($roleId == 10) $tab = "REVIEWED";                
            }
            else if( $stageId == 4){
                if($roleId == 11) $tab = "REVIEW";
                else if($roleId == 12) $tab = "PENDING";
                else if($roleId == 10) $tab = "REVIEWED";               
            }
            else if( $stageId == 5 ||  $stageId == 6){
                if($roleId == 11) $tab = "REVIEWED";
                else if($roleId == 12) $tab = "PENDING";
                else if($roleId == 10) $tab = "REVIEWED";
            }            
            else if( $stageId == 7){
                if($roleId == 11) $tab = "PENDING";
                else if($roleId == 12) $tab = "REVIEWED";
                else if($roleId == 10) $tab = "REVIEWED";                
            }
            else if( $stageId == 8){
                if($roleId == 11) $tab = "REVIEWED";
                else if($roleId == 12) $tab = "REVIEWED";
                else if($roleId == 10) $tab = "REVIEWED";                
            }            
        }
        
        return $tab;
    }

    public function calculatedTab($requestData){
        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "OBS")->pluck("ROLE_ID")->first();
        return $this -> mapRoleStageTab($requestData,$userRoles);
    }
    
    public function getObservationList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $tab = $requestData->TAB ?? "PENDING";

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "OBS")->pluck("ROLE_ID")->first();


        if(!empty($requestData->STAGE_ID)){
            $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        }        
        $query = Observation::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "OBSERVATION_REFERENCE_NO") {
                    //$query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                    $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "OBS_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "OBS_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        if (strtoupper($tab) == "PENDING") {
            if ($userRoles == 11) {
                $query->whereIn('STAGE_ID', [6,7]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 12) {
                $query->whereIn('STAGE_ID', [2,3,4,5,9,10]);
            }
        } elseif (strtoupper($tab) == "REVIEWED") {
            if ($userRoles == 11) {
                $query->whereIn('STAGE_ID', [2,3,4,5,8,9,10]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 12) {
                $query->whereIn('STAGE_ID', [6,7,8]);
            }elseif ($userRoles == 10) {
                $query->whereNotIn('STAGE_ID', [1]);
            }
        }elseif(strtoupper($tab) == "DRAFT"){
            if ($userRoles == 11) {
                $query->whereIn('STAGE_ID', [1]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            }
        }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);


        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        return $query->paginate($this->pageSize, ['*'], 'page', $this->page);
    }

    public function getObservationListTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        $tab = $requestData->TAB ?? "PENDING";
        $query = Observation::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage'];

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "OBS")->pluck("ROLE_ID")->first();

        if(!empty($requestData->STAGE_ID)){
            $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        }


        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "OBSERVATION_REFERENCE_NO") {
                   // $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                   $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "OBS_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "OBS_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        if (strtoupper($tab) == "PENDING") {
            if ($userRoles == 11) {
                $query->whereIn('STAGE_ID', [6,7]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 12) {
                $query->whereIn('STAGE_ID', [2,3,4,5,9,10]);
            }
        } elseif (strtoupper($tab) == "REVIEWED") {
            if ($userRoles == 11) {
                $query->whereIn('STAGE_ID', [2,3,4,5,8,9,10]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 12) {
                $query->whereIn('STAGE_ID', [6,7,8]);
            } elseif ($userRoles == 10) {
                $query->whereNotIn('STAGE_ID', [1]);
            }
        }elseif(strtoupper($tab) == "DRAFT"){
            if ($userRoles == 11) {
                $query->whereIn('STAGE_ID', [1]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            }
        }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->count();
    }

    public function getObservationDetails($requestData)
    {
        return Observation::where("ID", $requestData->OBS_ID)->first();
    }

    public function getAllObservation($requestData)
    {
        return Observation::where("SITE_ID", $requestData->SITE_ID)->where("IS_DELETED", 0)->get();
    }

    protected function getStages($requestAction)
    {
        $stageId = 1;
        if (strtoupper($requestAction) == "DRAFT") {
            $stageId = 1;
        } elseif (strtoupper($requestAction) == "SAVE") {
            $stageId = 2;
        } elseif (strtoupper($requestAction) == "MOVE_FORWARD") {
            $stageId = 3;
        } elseif (strtoupper($requestAction) == "SEND_BACK") {
            $stageId = 4;
        } elseif (strtoupper($requestAction) == "APPROVE") {
            $stageId = 5;
        } elseif (strtoupper($requestAction) == "REJECT") {
            $stageId = 6;
        } elseif (strtoupper($requestAction) == "REQUEST_FOR_CLOSURE") {
            $stageId = 7;
        } elseif (strtoupper($requestAction) == "CLOSE") {
            $stageId = 8;
        } elseif (strtoupper($requestAction) == "REPORTER_APPROVE") {
            $stageId = 9;
        } elseif (strtoupper($requestAction) == "REPORTER_REJECT") {
            $stageId = 10;
        }        
        return $stageId;
    }

    
    protected function transformObservationMapDeclarationTableData($requestData, $observationId)
    {
        $processedData = [];
        if (isset($requestData->DECLARATION_ID)) {
            if (count($requestData->DECLARATION_ID) > 0) {
                foreach (array_unique($requestData->DECLARATION_ID) as $value) {
                    $processedData[] = [
                        "OBS_ID" => $observationId,
                        "DECLARATION_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    protected function transformObservationMapDeclarationPopupTableData($requestData, $observationId)
    {
        $processedData = [];
        $popupDecl = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                    ->where("DECLARATION_GROUP", "OBS_ADD_POP_ONE")
                    ->pluck("DECLARATION_ID")->all();
        if (isset($popupDecl)) {
            if (count($popupDecl) > 0) {
                foreach ($popupDecl as $value) {
                    $processedData[] = [
                        "OBS_ID" => $observationId,
                        "DECLARATION_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    

    public function ObservationFileUpload($request, $observationId)
    {

        if ($observationId) {
            $uploadPath = './' . config('constants.OBS_FILE_UPLOAD_PATH');
            $absoluteBasePath = public_path(config('constants.OBS_FILE_UPLOAD_PATH'));
            if (!file_exists($uploadPath)) {
                mkdir($uploadPath, 0755, true);
            }

            $fileList = (isset($request->OBSERVATION_FILES)) ? $request->OBSERVATION_FILES : [];
            
            

            if (count($fileList)) {
                foreach ($fileList as $fileData) {
                    if ($fileData->FILE_ID == 0) {
                        $file = new ObservationMapFile([
                            'OBS_ID' => $observationId,
                            'FILE_NAME' => basename($fileData->FILE),
                            'FILE_CAPTION' => $fileData->FILE_CAPTION,
                            'FILE_PATH' => $fileData->FILE,
                            'SECTION' => "OBS_FILES",
                            'CREATED_BY' => $request->CREATED_BY,
                            "CREATED_ON" => currentDateTime()
                        ]);

                        $file->save();
                    } else {
                        //request for deletion of the file
                        $fileDetails = ObservationMapFile::where('MAP_FILE_ID', $fileData->FILE_ID)->first();
                        if ($fileDetails) {
                            $fileDeleted = ObservationMapFile::where('MAP_FILE_ID', $fileData->FILE_ID)->delete();
                            if ($fileDeleted) {
                                @unlink($absoluteBasePath . $fileDetails->FILE_NAME);
                            }
                        }
                    }
                }
            }

            $actionfileList = (isset($request->ACTION_TAKEN_FILES)) ? $request->ACTION_TAKEN_FILES : [];

            if (count($actionfileList)) {
                foreach ($actionfileList as $fileData) {
                    if ($fileData->FILE_ID == 0) {
                       
                        $file = new ObservationMapFile([
                            'OBS_ID' => $observationId,
                            'FILE_NAME' => basename($fileData->FILE),
                            'FILE_CAPTION' => $fileData->FILE_CAPTION,
                            'FILE_PATH' => $fileData->FILE,
                            "SECTION" => "ACTION_TAKEN",
                            'CREATED_BY' => $request->CREATED_BY,
                            "CREATED_ON" => currentDateTime()
                        ]);

                        $file->save();
                           
                       
                    } else {
                        //request for deletion of the file
                        $fileDetails = ObservationMapFile::where('MAP_FILE_ID', $fileData->FILE_ID)->first();
                        if ($fileDetails) {
                            $fileDeleted = ObservationMapFile::where('MAP_FILE_ID', $fileData->FILE_ID)->delete();
                            if ($fileDeleted) {
                                @unlink($absoluteBasePath . $fileDetails->FILE_NAME);
                            }
                        }
                    }
                }
            }
        }
    }


    

    protected function autoGenNumberGeneration($requestedData)
    {
        //$siteId = $requestedData -> SITE_ID;
        if($requestedData->ID > 0){
            $siteId = Observation::where("ID",$requestedData->ID)->pluck("LOCATION_ID")->first();
        }else{
            $siteId = $requestedData -> LOCATION_ID;
        }
        
        $siteAlias   = HiraMstLocation::where("LOCATION_ID", $siteId)->pluck("LOCATION_ALIAS")->first();   
        $initialSearch = "";
        //$initialSearch = "SHW_IND_";
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            $initialSearch = "DRAFT_";
        }
        else{
            $initialSearch = "SHW_IND_";
        }
        $previousNumber = DB::table('OBSERVATION')
                            ->where("LOCATION_ID", $siteId)
                            ->where("OBSERVATION_REFERENCE_NO", "LIKE", $initialSearch . strtoupper($siteAlias) . "%")
                            ->max(DB::raw("CAST(regexp_replace(\"OBSERVATION_REFERENCE_NO\", '\\D', '', 'g') AS INTEGER)"));
        $previousNumber = $previousNumber ?: 0;

        // Define prefix and suffix
        $prefix = config("constants.OBS_REFERENCE_PREFIX");
        //$typeAlias = ObservationMstType::where("OBS_TYPE_ID", $requestedData -> OBS_TYPE_ID)->pluck("TYPE_ALIAS")->first();
        
        $prefixMod = config("constants.OBS_PREFIX");
        //$middle = "_".$typeAlias."_"; 
        $middle = "_".$prefixMod;           
        
        // Increment the last digit based on the value of $previousNumber
        $lastDigit = $previousNumber + 1;

        // Concatenate all parts to form the output
        //return $prefix . strtoupper($siteAlias) . $middle . $lastDigit;
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            return $initialSearch.strtoupper($siteAlias)."-".$lastDigit;
        }else{
            return $prefix . strtoupper($siteAlias) . $middle . $lastDigit;
        }
    }

    protected function transformObservationTableData($requestData)
    {
        if (in_array(strtoupper($requestData->ACTION), ["DRAFT", "SAVE","RENEW"])) {

            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];

            if (isset($requestData->SITE_ID)) {
                $processedData["SITE_ID"]  =  $requestData->SITE_ID;
            }
            if (isset($requestData->OBS_TYPE_ID)) {
                $processedData["OBS_TYPE_ID"]  =  $requestData->OBS_TYPE_ID;
            }
            if (isset($requestData->LOCATION_ID)) {
                $processedData["LOCATION_ID"]  =  $requestData->LOCATION_ID;
            }
            if (isset($requestData->OBS_START_DATE)) {
                $processedData["OBS_START_DATE"]  = createSlashDate($requestData->OBS_START_DATE, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->OBS_END_DATE)) {
                $processedData["OBS_END_DATE"]  = createSlashDate($requestData->OBS_END_DATE, config("constants.DATE_TIME_FORMAT"));
            }                         
            if (isset($requestData->DESCRIPTION)) {
                $processedData["DESCRIPTION"]  =  $requestData->DESCRIPTION;
            }
            if (isset($requestData->SEVERITY_ID)) {
                $processedData["SEVERITY_ID"]  =  $requestData->SEVERITY_ID;
            }
            if (isset($requestData->LIKELIHOOD_ID)) {
                $processedData["LIKELIHOOD_ID"]  =  $requestData->LIKELIHOOD_ID;
            }
            if (isset($requestData->ACTION_OWNER_ID)) {
                $processedData["ACTION_OWNER_ID"]  =  $requestData->ACTION_OWNER_ID;
            }
            if (isset($requestData->TARGET_TIMELINE)) {
                $processedData["TARGET_TIMELINE"]  = createSlashDate($requestData->TARGET_TIMELINE, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->RECOMMENDATION)) {
                $processedData["RECOMMENDATION"]  =  $requestData->RECOMMENDATION;
            }
            if( strtoupper($requestData->ACTION) == "DRAFT"){
                if ($requestData->ID == 0 ) {               
                    $processedData["OBSERVATION_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                    $processedData["REPORTED_BY_ID"]  =  $requestData->CREATED_BY;
                }
            }
            if( strtoupper($requestData->ACTION) == "SAVE"){
                if ($requestData->ID == 0 ) {               
                    $processedData["OBSERVATION_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                    $processedData["REPORTED_BY_ID"]  =  $requestData->CREATED_BY;
                }
                if ($requestData->ID > 0 ) { 
                    $obsDraftAlready = Observation::where("ID",$requestData->ID)->where("OBSERVATION_REFERENCE_NO","LIKE","DRAFT_%");              
                    if($obsDraftAlready -> exists()){
                        $processedData["OBSERVATION_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                    }                                        
                }               
            }             
        } else {             
                       
            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];
            if (isset($requestData->ACTION_COMPLETED_DATE)) {
                $processedData["ACTION_COMPLETED_DATE"]  = createSlashDate($requestData->ACTION_COMPLETED_DATE, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->ACTION_TAKEN_DETAILS)) {
                $processedData["ACTION_TAKEN_DETAILS"]  = $requestData->ACTION_TAKEN_DETAILS;
            } 
            if (isset($requestData->REVISE_TIMELINE)) {
                $processedData["REVISE_TIMELINE"]  = createSlashDate($requestData->REVISE_TIMELINE, config("constants.DATE_TIME_FORMAT"));
                $processedData["TARGET_TIMELINE"]  = createSlashDate($requestData->REVISE_TIMELINE, config("constants.DATE_TIME_FORMAT"));
            }             
        }
        
        if (isset($requestData->ID) &&  $requestData->ID > 0) {
            $processedData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedData["MODIFIED_ON"] = currentDateTime();
        } else {
            $processedData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedData["CREATED_ON"] = currentDateTime();
        }
        return $processedData;
    }
    public function save($requestData)
    {        
        $observationId = "";
        if (isset($requestData->ID) && $requestData->ID) {
            $observationId = Observation::where("ID", $requestData->ID)->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->pluck("ID")->first();
            $observationStageId = Observation::where("ID", $requestData->ID)->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->pluck("STAGE_ID")->first();
            $requestedStageId = $this -> getStages($requestData->ACTION);
            
            /**if( in_array($observationStageId,[4,6])){
                if( $requestedStageId ==1 ){

                }else{
                    if($observationStageId > $requestedStageId){
                        return "";
                    }
                }                
            }else if($observationStageId !=1 && ($observationStageId  == $requestedStageId)){
                return "";
            }
            else{
                if($observationStageId > $requestedStageId){
                    return "";
                }
            }*/
        } 
       
        
        DB::beginTransaction();
        try {
            if (isset($requestData->ACTION) && strtoupper($requestData->ACTION) == "RENEW") {
                $observationId = $this -> renewal($requestData);
            }else{
                $processedData = $this->transformObservationTableData($requestData);
                if ($observationId > 0) {
                    //update Observation tables and upsert all associated tables
                    Observation::where("ID", $observationId)->update($processedData);
                } else {
                    //insert Observation tables and insert all associated tables
                    //insert into Observation table
                    $observationInsert = Observation::create($processedData);
                    $observationId = $observationInsert->ID;
                }
                

                //insert into OBS_MAP_DECLARATION
                $observationMapDeclarationData = $this->transformObservationMapDeclarationTableData($requestData, $observationId);
                if (count($observationMapDeclarationData)) {
                    //soft delete old data if exists
                    $addRequestClass = new AddRequest();
                    $declarationSectionId = $addRequestClass->getDeclarationSectionbyAction($requestData->ACTION);
                    
                    if ($declarationSectionId == 1) {
                        $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP",'OBS_ADD')->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 2) {
                        $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "OBS_MOVE_FORWARD")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 3) {
                        $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "OBS_ACCEPT_TIMELINE")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 4) {
                        $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "OBS_REJECT")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 5) {
                        $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "OBS_REQUEST_FOR_CLOSURE")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 6) {
                        $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "OBS_CLOSE")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 7) {
                        $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "OBS_SUSPEND")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 8) {
                        $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "OBS_REQUEST_FOR_SUSPEND")->pluck("DECLARATION_ID")->all();
                    } else {
                        $allDeclarationData = ObservationMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->whereNot("DECLARATION_GROUP", "OBS_ADD")->pluck("DECLARATION_ID")->all();
                    } 
                    
                    ObservationMapDeclaration::where("OBS_ID", $observationId)->where("IS_DELETED", 0)
                        ->whereIn("DECLARATION_ID", $allDeclarationData)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                        ]);
                    //insert new data
                    ObservationMapDeclaration::insert($observationMapDeclarationData);
                }
                
               
                //insert into Observation_MAP_FILES
                $this->ObservationFileUpload($requestData, $observationId);
                //insert into log table
                ObservationActionHistory::insert(
                    [
                        "OBS_ID" => $observationId,
                        "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                        "STAGE_ID"  => $this->getStages($requestData->ACTION),
                        "COMMENTS"  => $requestData->REMARKS ?? "",
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ]
                );

                if (isset($requestData->ACTION_TAKEN_DETAILS)) {
                   //insert into Action Details log table
                   ObservationActionTakenDetailsLog::insert(
                        [
                            "OBS_ID" => $observationId,
                            "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                            "STAGE_ID"  => $this->getStages($requestData->ACTION),
                            "COMMENTS"  => $requestData->ACTION_TAKEN_DETAILS ?? "",
                            "CREATED_BY" => $requestData->CREATED_BY,
                            "CREATED_ON" => currentDateTime()
                        ]
                    ); 
                }
            }
            $stage_id = $this->getStages($requestData->ACTION);
            //  $this->vvsObsSendMailService->obsSendMail($stage_id,$observationId);
             DB::commit();

            // If the transaction is committed successfully, you can return a response or perform other actions
            if($observationId != ""){
                return Observation::where("ID", $observationId)->pluck("OBSERVATION_REFERENCE_NO")->first();
            }else{
                return "";
            }
        } catch (\Exception $e) {
            // If an exception occurs during the transaction, rollback the changes
             DB::rollBack();
            prd($e->getMessage());
            // You can handle the exception here, log it, or return an error response
             return "";
         }
    }

    public function getObservationDownloadableList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = Observation::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage','obstype','severity','likelihood',
                            'actionOwner','reportedBy','observationFiles','actionTakenFiles',
                            'reportedbyhistory','approvedbyhistory','approvedbyhistory2','closedbyhistory'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "OBSERVATION_REFERENCE_NO") {
                    //$query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                    $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "OBS_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "OBS_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
      
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        $query->with(['reportedbyhistory.actionTracker']);
        $query->with(['approvedbyhistory.actionTracker']);
        $query->with(['approvedbyhistory2.actionTracker']);
        $query->with(['closedbyhistory.actionTracker']);

        // Fetch action history data
        return  $query->get();
    }

    public function getSearchCriteriaList($requestData)
    {
        $searchCriteria =[];
        if (!empty($requestData->OBS_TYPE_ID) && isset($requestData->OBS_TYPE_ID)) {
            $type = ObservationMstType::find($requestData->OBS_TYPE_ID);
            if ($type) {
                $typeName = $type->OBS_TYPE_NAME;
            }
        }
        if (!empty($requestData->LOCATION_ID) && isset($requestData->LOCATION_ID)) {
            $location = HiraMstLocation::find($requestData->LOCATION_ID);
            if ($location) {
                $locationName = $location->LOCATION_NAME;
            }
        }
        if (!empty($requestData->SITE_ID) && isset($requestData->SITE_ID)) {
            $site = MstSite::find($requestData->SITE_ID);
            if ($site) {
                $siteName = $site->SITE_NAME;
            }
        }

        if(isset($requestData->SITE_ID)){
            $searchCriteria["SITE_NAME"] = $siteName;
        }
        if(isset($requestData->OBS_TYPE_ID)){
            $searchCriteria["OBS_TYPE_NAME"] = $typeName;
        }
        if(isset($requestData->OBSERVATION_REFERENCE_NO)){
            $searchCriteria["OBSERVATION_REFERENCE_NO"] = $requestData->OBSERVATION_REFERENCE_NO;
        }
        if(isset($requestData->LOCATION_ID)){
            $searchCriteria["LOCATION_NAME"] = $locationName;
        }

        return $searchCriteria;
    }

    public function commentLog($obsId){
        $actionHistories = ObservationActionHistory::select('OBS_ACTION_HISTORY.COMMENTS',
         'OBS_ACTION_HISTORY.CREATED_ON', 'u.FIRST_NAME', 'u.LAST_NAME','u.IS_INFO_REDUCTED','s.STAGE_NAME')
                            ->leftJoin('USERS as u', 'u.ID', '=', 'OBS_ACTION_HISTORY.ACTION_TAKER_ID')
                            ->leftJoin('OBS_MST_STAGE as s', 's.STAGE_ID', '=', 'OBS_ACTION_HISTORY.STAGE_ID')
                            ->where('OBS_ACTION_HISTORY.OBS_ID', $obsId)
                            //->where('OBS_ACTION_HISTORY.COMMENTS', '!=', '')
                           ->orderBy("OBS_ACTION_HISTORY.CREATED_ON","desc")
                            ->get();
                           
        $commentsLog = array();
        foreach ($actionHistories->toArray() as $actionHistory) {
            // Access data from each row
            $comments = $actionHistory["COMMENTS"];
            $createdOn = $actionHistory["CREATED_ON"];
            $firstName = $actionHistory["FIRST_NAME"];
            $lastName = $actionHistory["LAST_NAME"];
            $infoReducted = $actionHistory["IS_INFO_REDUCTED"];
            $stageName = $actionHistory["STAGE_NAME"];

            $commentsLog[] = [
                'COMMENTS' => $comments,
                'CREATED_DATE' => $createdOn,
                'NAME' => ($infoReducted == 0) ? ($this->customDecrypt($firstName) . ' ' . $this->customDecrypt($lastName)) : "-",
                'OBSERVATION_STAGE' => $stageName
            ];
            
            // Do something with the retrieved data
        }
        return $commentsLog;

    }
    // public function actionTakenLog($obsId){
    //     $actionHistories = Observation ::select('OBSERVATION.ACTION_TAKEN_DETAILS', 'OBSERVATION.ACTION_COMPLETED_DATE', 'u.FIRST_NAME', 'u.LAST_NAME')
    //                         ->leftJoin('USERS as u', 'u.ID', '=', 'OBS_ACTION_HISTORY.ACTION_TAKER_ID')
    //                         ->where('OBS_ACTION_HISTORY.OBS_ID', $obsId)
    //                        // ->where('oah.COMMENTS', '!=', '')
    //                        ->orderBy("OBS_ACTION_HISTORY.CREATED_ON","desc")
    //                         ->get();
                           
    //     $commentsLog = array();
    //     foreach ($actionHistories->toArray() as $actionHistory) {
    //         // Access data from each row
    //         $comments = $actionHistory["COMMENTS"];
    //         $createdOn = $actionHistory["CREATED_ON"];
    //         $firstName = $actionHistory["FIRST_NAME"];
    //         $lastName = $actionHistory["LAST_NAME"];

    //         $commentsLog[] = [
    //             'COMMENTS' => $comments,
    //             'CREATED_DATE' => $createdOn,
    //             'NAME' => $firstName." ".$lastName
    //         ];
            
    //         // Do something with the retrieved data
    //     }
    //     return $commentsLog;
    // }


    public function saveObsDeclarationM($requestData)
    {        
        DB::beginTransaction();
        try {
            $obsId = 0;
            $obsMapDeclarationData = $this->transformObservationMapDeclarationTableData($requestData, $obsId);
            //insert new data
            $obsinsert = ObservationMapDeclarationForM::insert($obsMapDeclarationData);
            DB::commit();
            if($obsinsert){
                return 1;
            }else{
                return "";
            }
        } catch (\Exception $e) {
            // If an exception occurs during the transaction, rollback the changes
            DB::rollBack();
            prd($e->getMessage());
            // You can handle the exception here, log it, or return an error response
            return "";
        }
        
    }
    
}