<?php

namespace App\Services\OBSERVATION;

use App\Http\Requests\OBSERVATION\AddRequest;
use App\Http\Resources\OBSERVATION\ObservationResource;
use App\Models\MstSite;
use App\Models\Observation;
use App\Models\User;
use App\Models\UserMapRole;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;

class ObservationSendMailServices extends ObservationResource
{
    public $vvsObsModel;    
    public function __construct()
    {
        $this->vvsObsModel = new Observation();
    }

    public function obsSendMail($stage_id,$obs_id){
        if($stage_id == 2){
            $this->sendApprovalMail($obs_id);
        }
        if($stage_id == 4){
            $this->sendSendBackMail($obs_id);
        }
        if($stage_id == 5 || $stage_id == 9){
            $this->sendApprovedMail($obs_id);
        }
        if($stage_id == 6 || $stage_id == 10){
            $this->sendRejectedMail($obs_id);
        }
        if($stage_id == 7){
            $this->sendCloseRequestMail($obs_id);
        }
        if($stage_id == 8){
            $this->sendClosedMail($obs_id);
        }
        
    }

    protected function getObsUserList($site_id,$role_id) {
        return User::select(
            'USERS.ID', 
            'USERS.FIRST_NAME', 
            'USERS.LAST_NAME', 
            'USERS.EMAIL',
            'MST_ROLE.ROLE_NAME'            
            )
            ->leftJoin('USERS_MAP_ROLE', 'USERS_MAP_ROLE.USER_ID', '=', 'USERS.ID')
            ->leftJoin('USERS_MAP_SITE', 'USERS_MAP_SITE.USER_ID', '=', 'USERS.ID')
            ->leftJoin('MST_ROLE', 'USERS_MAP_ROLE.ROLE_ID', '=', 'MST_ROLE.ROLE_ID')                                  
            ->where("USERS_MAP_SITE.SITE_ID",$site_id)
            ->where("USERS_MAP_ROLE.MODULE_NAME","OBS")
            ->where("USERS_MAP_ROLE.ROLE_ID",$role_id)
            ->where("USERS.IS_ACTIVE",1)
            ->where("USERS.IS_DELETED",0)
            ->where("USERS_MAP_ROLE.IS_ACTIVE",1)
            ->where("USERS_MAP_ROLE.IS_DELETED",0)
            ->where("USERS_MAP_SITE.IS_ACTIVE",1)
            ->where("USERS_MAP_SITE.IS_DELETED",0)
            ->where("MST_ROLE.IS_ACTIVE",1)
            ->where("MST_ROLE.IS_DELETED",0)            
            ->get();    
    }

    protected function sendApprovalMail($obs_id){
        $obsdetails = Observation::where("ID", $obs_id)->first();
        $reportedby = $obsdetails->reportedby;
        $mapRole = $reportedby->obsroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:blue;">OBSERVATION PENDING FOR REVIEWER / APPROVAL</h1></p>';
        $mailBody.="<p>The Observation as referred below has been submitted by 
        ".$this->customDecrypt($obsdetails->reportedby->FIRST_NAME).' '.$this->customDecrypt($obsdetails->reportedby->LAST_NAME)." [".$roleName."] 
        and now pending for your Review / approval.
        </p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$obsdetails->OBSERVATION_REFERENCE_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($obsdetails->OBS_START_DATE, config("constants.DATE_FORMAT")).
        ' - '.showDate($obsdetails->OBS_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$obsdetails->obstype->OBS_TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>Observation Details:</td><td>'.$obsdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>location:</td><td>'.$obsdetails->location->LOCATION_NAME.'</td></tr>';
        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';        
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";

        $to_email = $this->customDecrypt($obsdetails->actionOwner->EMAIL);
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
            $message->to($data['to_email']);
            $message->subject('OBSERVATION PENDING FOR REVIEWER / APPROVAL');
            $message->html($data['body']);
            $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

    protected function sendSendBackMail($obs_id){
        $obsdetails = Observation::where("ID", $obs_id)->first();
        $rejectedByName = $this->customDecrypt($obsdetails->reportedby->FIRST_NAME).' '.$this->customDecrypt($obsdetails->reportedby->LAST_NAME);
        $rejectedBy = $obsdetails->reportedby;
        $mapRole = $rejectedBy->obsroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:red;">OBSERVATION SEND BACK</h1></p>';
        $mailBody.="<p>The Observation timeline as referred below has been sent back by ".$rejectedByName." [".$roleName."]
         and now pending for necessary correction and resubmission.</p>";
         $mailBody.='<table border="1">';
         $mailBody.='<tr><td>Ref. No.:</td><td>'.$obsdetails->OBSERVATION_REFERENCE_NO.'</td></tr>';
         $mailBody.='<tr><td>Duration:</td><td>'.showDate($obsdetails->OBS_START_DATE, config("constants.DATE_FORMAT")).
         ' - '.showDate($obsdetails->OBS_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';
         $mailBody.='<tr><td>Type:</td><td>'.$obsdetails->obstype->OBS_TYPE_NAME.'</td></tr>';
         $mailBody.='<tr><td>Observation Details:</td><td>'.$obsdetails->DESCRIPTION.'</td></tr>';
         $mailBody.='<tr><td>location:</td><td>'.$obsdetails->location->LOCATION_NAME.'</td></tr>';
         $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $to_email = $this->customDecrypt($obsdetails->actionOwner->EMAIL);
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('OBSERVATION SEND BACK');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

    protected function sendApprovedMail($obs_id){
        $obsdetails = Observation::where("ID", $obs_id)->first();
        if($obsdetails->STAGE_ID == 5){
            $approvedByName = $this->customDecrypt($obsdetails->actionOwner->FIRST_NAME).' '.$this->customDecrypt($obsdetails->actionOwner->LAST_NAME);
            $approvedBy = $obsdetails->actionOwner;
        }else{
            $approvedByName = $this->customDecrypt($obsdetails->reportedby->FIRST_NAME).' '.$this->customDecrypt($obsdetails->reportedby->LAST_NAME);
            $approvedBy = $obsdetails->reportedby;
        }
        $mapRole = $approvedBy->obsroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:green;">OBSERVATION TIMLEINE ACCEPTED</h1></p>';
        $mailBody.="<p>The Observation as referred below has been approved by ".$approvedByName." [".$roleName."].</p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$obsdetails->OBSERVATION_REFERENCE_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($obsdetails->OBS_START_DATE, config("constants.DATE_FORMAT")).
        ' - '.showDate($obsdetails->OBS_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$obsdetails->obstype->OBS_TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>Observation Details:</td><td>'.$obsdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>location:</td><td>'.$obsdetails->location->LOCATION_NAME.'</td></tr>';
        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        if($obsdetails->STAGE_ID == 5){
            $to_email = $this->customDecrypt($obsdetails->reportedby->EMAIL);
        }else{
            $to_email = $this->customDecrypt($obsdetails->actionOwner->EMAIL);
        }
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
            $message->to($data['to_email']);
            $message->subject('OBSERVATION TIMELINE ACCEPTED');
            $message->html($data['body']);
            $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

    protected function sendRejectedMail($obs_id){
        $obsdetails = Observation::where("ID", $obs_id)->first();
        if($obsdetails->STAGE_ID == 6){
            $rejectedByName = $this->customDecrypt($obsdetails->actionOwner->FIRST_NAME).' '.$this->customDecrypt($obsdetails->actionOwner->LAST_NAME);
            $rejectedBy = $obsdetails->actionOwner;
        }else{
            $rejectedByName = $this->customDecrypt($obsdetails->reportedby->FIRST_NAME).' '.$this->customDecrypt($obsdetails->reportedby->LAST_NAME);
            $rejectedBy = $obsdetails->reportedby;
        }
        $mapRole = $rejectedBy->obsroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:red;">OBSERVATION TIMELINE REVISED</h1></p>';
        $mailBody.="<p>The Observation timeline as referred below has been revised by ".$rejectedByName." [".$roleName."]
         and now pending for necessary correction and resubmission.</p>";
         $mailBody.='<table border="1">';
         $mailBody.='<tr><td>Ref. No.:</td><td>'.$obsdetails->OBSERVATION_REFERENCE_NO.'</td></tr>';
         $mailBody.='<tr><td>Duration:</td><td>'.showDate($obsdetails->OBS_START_DATE, config("constants.DATE_FORMAT")).
         ' - '.showDate($obsdetails->OBS_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';
         $mailBody.='<tr><td>Type:</td><td>'.$obsdetails->obstype->OBS_TYPE_NAME.'</td></tr>';
         $mailBody.='<tr><td>Observation Details:</td><td>'.$obsdetails->DESCRIPTION.'</td></tr>';
         $mailBody.='<tr><td>location:</td><td>'.$obsdetails->location->LOCATION_NAME.'</td></tr>';
         $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        if($obsdetails->STAGE_ID == 6){
            $to_email = $this->customDecrypt($obsdetails->reportedby->EMAIL);
        }else{
            $to_email = $this->customDecrypt($obsdetails->actionOwner->EMAIL);
        }
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('OBSERVATION TIMELINE REVISED');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }


    protected function sendCloseRequestMail($obs_id){
        $obsdetails = Observation::where("ID", $obs_id)->first();
        $closedBy = $obsdetails->actionOwner;
        $mapRole = $closedBy->obsroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $closedReqBy = $this->customDecrypt($obsdetails->actionOwner->FIRST_NAME).' '.$this->customDecrypt($obsdetails->actionOwner->LAST_NAME);
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1  style="color:blue;">OBSERVATION CLOSURE REQUESTED</h1></p>';
        $mailBody.="<p>The Observation as referred below has been requested to be closed by ".$closedReqBy." 
        [".$roleName."] and now pending for your Action.</p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$obsdetails->OBSERVATION_REFERENCE_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($obsdetails->OBS_START_DATE, config("constants.DATE_FORMAT")).
        ' - '.showDate($obsdetails->OBS_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$obsdetails->obstype->OBS_TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>Observation Details:</td><td>'.$obsdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>location:</td><td>'.$obsdetails->location->LOCATION_NAME.'</td></tr>';
        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";

        $to_email = $this->customDecrypt($obsdetails->reportedby->EMAIL);
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
            $message->to($data['to_email']);
            $message->subject('OBSERVATION CLOSURE REQUESTED');
            $message->html($data['body']);
            $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

    protected function sendClosedMail($obs_id){
        $obsdetails = Observation::where("ID", $obs_id)->first();
        $reportedby = $obsdetails->reportedby;
        $mapRole = $reportedby->obsroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $closedBy = $this->customDecrypt($obsdetails->reportedby->FIRST_NAME).' '.$this->customDecrypt($obsdetails->reportedby->LAST_NAME);
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:green;">OBSERVATION CLOSED</h1></p>';
        $mailBody.="<p>The Observation as referred below has been closed by ".$closedBy." [".$roleName."].</p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$obsdetails->OBSERVATION_REFERENCE_NO.'</td></tr>';
        $mailBody.='<tr><td>Duration:</td><td>'.showDate($obsdetails->OBS_START_DATE, config("constants.DATE_FORMAT")).
        ' - '.showDate($obsdetails->OBS_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$obsdetails->obstype->OBS_TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>Observation Details:</td><td>'.$obsdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>location:</td><td>'.$obsdetails->location->LOCATION_NAME.'</td></tr>';
        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $to_email = $this->customDecrypt($obsdetails->actionOwner->EMAIL);
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
            $message->to($data['to_email']);
            $message->subject('OBSERVATION CLOSED');
            $message->html($data['body']);
            $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

    

    
}
